/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.transport;

import axion.org.eclipse.jgit.errors.NotSupportedException;
import axion.org.eclipse.jgit.errors.TransportException;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.transport.BundleFetchConnection;
import axion.org.eclipse.jgit.transport.FetchConnection;
import axion.org.eclipse.jgit.transport.PushConnection;
import axion.org.eclipse.jgit.transport.Transport;
import axion.org.eclipse.jgit.transport.TransportBundle;
import axion.org.eclipse.jgit.transport.URIish;
import java.io.IOException;
import java.io.InputStream;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                try {
                    this.src.close();
                }
                catch (IOException iOException) {
                    this.src = null;
                }
            }
            finally {
                this.src = null;
            }
        }
    }
}

