/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.transport;

import axion.org.eclipse.jgit.annotations.Nullable;
import axion.org.eclipse.jgit.lib.Config;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.transport.DaemonClient;
import axion.org.eclipse.jgit.transport.PacketLineOut;
import axion.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import axion.org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import axion.org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import java.io.IOException;
import java.util.Collection;

public abstract class DaemonService {
    private final String command;
    private final Config.SectionParser<ServiceConfig> configKey;
    private boolean enabled;
    private boolean overridable;

    DaemonService(String cmdName, String cfgName) {
        this.command = cmdName.startsWith("git-") ? cmdName : "git-" + cmdName;
        this.configKey = cfg -> new ServiceConfig(this, cfg, cfgName);
        this.overridable = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean on) {
        this.overridable = on;
    }

    public String getCommandName() {
        return this.command;
    }

    public boolean handles(String commandLine) {
        return this.command.length() + 1 < commandLine.length() && commandLine.charAt(this.command.length()) == ' ' && commandLine.startsWith(this.command);
    }

    void execute(DaemonClient client, String commandLine, @Nullable Collection<String> extraParameters) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
        String name = commandLine.substring(this.command.length() + 1);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Repository db = client.getDaemon().openRepository(client, name);){
                if (this.isEnabledFor(db)) {
                    this.execute(client, db, extraParameters);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ServiceMayNotContinueException e) {
            PacketLineOut pktOut = new PacketLineOut(client.getOutputStream());
            pktOut.writeString("ERR " + e.getMessage() + "\n");
        }
    }

    private boolean isEnabledFor(Repository db) {
        if (this.isOverridable()) {
            return db.getConfig().get(this.configKey).enabled;
        }
        return this.isEnabled();
    }

    abstract void execute(DaemonClient var1, Repository var2, @Nullable Collection<String> var3) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException;

    private static class ServiceConfig {
        final boolean enabled;

        ServiceConfig(DaemonService service, Config cfg, String name) {
            this.enabled = cfg.getBoolean("daemon", name, service.isEnabled());
        }
    }
}

