/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.revwalk.filter;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import axion.org.eclipse.jgit.revwalk.filter.RevFilter;
import axion.org.eclipse.jgit.util.RawCharSequence;
import axion.org.eclipse.jgit.util.RawSubStringPattern;
import java.io.IOException;

public abstract class SubStringRevFilter
extends RevFilter {
    private final RawSubStringPattern pattern;

    public static boolean safe(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected SubStringRevFilter(String patternText) {
        this.pattern = new RawSubStringPattern(patternText);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pattern.match(this.text(cmit)) >= 0;
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract RawCharSequence text(RevCommit var1);

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(\"" + this.pattern.pattern() + "\")";
    }
}

