/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.revwalk;

import axion.org.eclipse.jgit.annotations.Nullable;
import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.lib.AnyObjectId;
import axion.org.eclipse.jgit.lib.Constants;
import axion.org.eclipse.jgit.lib.MutableObjectId;
import axion.org.eclipse.jgit.lib.ObjectInserter;
import axion.org.eclipse.jgit.lib.PersonIdent;
import axion.org.eclipse.jgit.revwalk.FIFORevQueue;
import axion.org.eclipse.jgit.revwalk.FooterKey;
import axion.org.eclipse.jgit.revwalk.FooterLine;
import axion.org.eclipse.jgit.revwalk.RevFlag;
import axion.org.eclipse.jgit.revwalk.RevObject;
import axion.org.eclipse.jgit.revwalk.RevTree;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import axion.org.eclipse.jgit.util.RawParseUtils;
import axion.org.eclipse.jgit.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RevCommit
extends RevObject {
    private static final int STACK_DEPTH = 500;
    static final RevCommit[] NO_PARENTS = new RevCommit[0];
    private RevTree tree;
    RevCommit[] parents;
    int commitTime;
    int inDegree;
    private byte[] buffer;

    public static RevCommit parse(byte[] raw) {
        try {
            return RevCommit.parse(new RevWalk(null), raw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RevCommit parse(RevWalk rw, byte[] raw) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();){
            RevCommit r = rw.lookupCommit(fmt.idFor(1, raw));
            r.parseCanonical(rw, raw);
            r.buffer = raw;
            return r;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected RevCommit(AnyObjectId id) {
        super(id);
    }

    @Override
    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk, walk.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk, byte[] raw) throws IOException {
        if (!walk.shallowCommitsInitialized) {
            walk.initializeShallowCommits(this);
        }
        MutableObjectId idBuffer = walk.idBuffer;
        idBuffer.fromString(raw, 5);
        this.tree = walk.lookupTree(idBuffer);
        int ptr = 46;
        if (this.parents == null) {
            RevCommit[] pList = new RevCommit[1];
            int nParents = 0;
            while (raw[ptr] == 112) {
                idBuffer.fromString(raw, ptr + 7);
                RevCommit p = walk.lookupCommit(idBuffer);
                switch (nParents) {
                    case 0: {
                        pList[nParents++] = p;
                        break;
                    }
                    case 1: {
                        pList = new RevCommit[]{pList[0], p};
                        nParents = 2;
                        break;
                    }
                    default: {
                        if (pList.length <= nParents) {
                            RevCommit[] old = pList;
                            pList = new RevCommit[pList.length + 32];
                            System.arraycopy(old, 0, pList, 0, nParents);
                        }
                        pList[nParents++] = p;
                    }
                }
                ptr += 48;
            }
            if (nParents != pList.length) {
                RevCommit[] old = pList;
                pList = new RevCommit[nParents];
                System.arraycopy(old, 0, pList, 0, nParents);
            }
            this.parents = pList;
        }
        if ((ptr = RawParseUtils.committer(raw, ptr)) > 0) {
            ptr = RawParseUtils.nextLF(raw, ptr, '>');
            this.commitTime = RawParseUtils.parseBase10(raw, ptr, null);
        }
        if (walk.isRetainBody()) {
            this.buffer = raw;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 1;
    }

    static void carryFlags(RevCommit c, int carry) {
        FIFORevQueue q = RevCommit.carryFlags1(c, carry, 0);
        if (q != null) {
            RevCommit.slowCarryFlags(q, carry);
        }
    }

    private static FIFORevQueue carryFlags1(RevCommit c, int carry, int depth) {
        RevCommit[] pList;
        while ((pList = c.parents) != null && pList.length != 0) {
            if (pList.length != 1) {
                if (depth == 500) {
                    return RevCommit.defer(c);
                }
                int i = 1;
                while (i < pList.length) {
                    RevCommit p = pList[i];
                    if ((p.flags & carry) != carry) {
                        p.flags |= carry;
                        FIFORevQueue q = RevCommit.carryFlags1(p, carry, depth + 1);
                        if (q != null) {
                            return RevCommit.defer(q, carry, pList, i + 1);
                        }
                    }
                    ++i;
                }
            }
            c = pList[0];
            if ((c.flags & carry) == carry) {
                return null;
            }
            c.flags |= carry;
        }
        return null;
    }

    private static FIFORevQueue defer(RevCommit c) {
        FIFORevQueue q = new FIFORevQueue();
        q.add(c);
        return q;
    }

    private static FIFORevQueue defer(FIFORevQueue q, int carry, RevCommit[] pList, int i) {
        RevCommit.carryOneStep(q, carry, pList[0]);
        while (i < pList.length) {
            RevCommit.carryOneStep(q, carry, pList[i]);
            ++i;
        }
        return q;
    }

    private static void slowCarryFlags(FIFORevQueue q, int carry) {
        RevCommit c;
        while ((c = q.next()) != null) {
            RevCommit[] revCommitArray = c.parents;
            int n = c.parents.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                RevCommit.carryOneStep(q, carry, p);
                ++n2;
            }
        }
    }

    private static void carryOneStep(FIFORevQueue q, int carry, RevCommit c) {
        if ((c.flags & carry) != carry) {
            c.flags |= carry;
            if (c.parents != null) {
                q.add(c);
            }
        }
    }

    public void carry(RevFlag flag) {
        int carry = this.flags & flag.mask;
        if (carry != 0) {
            RevCommit.carryFlags(this, carry);
        }
    }

    public final int getCommitTime() {
        return this.commitTime;
    }

    public final RevTree getTree() {
        return this.tree;
    }

    public final int getParentCount() {
        return this.parents.length;
    }

    public final RevCommit getParent(int nth) {
        return this.parents[nth];
    }

    public final RevCommit[] getParents() {
        return this.parents;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final byte[] getRawGpgSignature() {
        byte[] raw = this.buffer;
        byte[] header = new byte[]{103, 112, 103, 115, 105, 103};
        int start = RawParseUtils.headerStart(header, raw, 0);
        if (start < 0) {
            return null;
        }
        int end = RawParseUtils.headerEnd(raw, start);
        return Arrays.copyOfRange(raw, start, end);
    }

    public final PersonIdent getAuthorIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.author(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final PersonIdent getCommitterIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.committer(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final String getFullMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        return RawParseUtils.decode(this.guessEncoding(), raw, msgB, raw.length);
    }

    public final String getShortMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        int msgE = RawParseUtils.endOfParagraph(raw, msgB);
        String str = RawParseUtils.decode(this.guessEncoding(), raw, msgB, msgE);
        if (RevCommit.hasLF(raw, msgB, msgE)) {
            str = StringUtils.replaceLineBreaksWithSpace(str);
        }
        return str;
    }

    static boolean hasLF(byte[] r, int b, int e) {
        while (b < e) {
            if (r[b++] != 10) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final String getEncodingName() {
        return RawParseUtils.parseEncodingName(this.buffer);
    }

    public final Charset getEncoding() {
        return RawParseUtils.parseEncoding(this.buffer);
    }

    private Charset guessEncoding() {
        try {
            return this.getEncoding();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return StandardCharsets.UTF_8;
        }
    }

    public final List<FooterLine> getFooterLines() {
        int keyStart;
        byte[] raw = this.buffer;
        int ptr = raw.length - 1;
        while (raw[ptr] == 10) {
            --ptr;
        }
        int msgB = RawParseUtils.commitMessage(raw, 0);
        ArrayList<FooterLine> r = new ArrayList<FooterLine>(4);
        Charset enc = this.guessEncoding();
        while ((ptr = RawParseUtils.prevLF(raw, ptr)) > msgB && raw[keyStart = ptr + 2] != 10) {
            int keyEnd = RawParseUtils.endOfFooterLineKey(raw, keyStart);
            if (keyEnd < 0) continue;
            int valStart = keyEnd + 1;
            while (valStart < raw.length && raw[valStart] == 32) {
                ++valStart;
            }
            int valEnd = RawParseUtils.nextLF(raw, valStart);
            if (raw[valEnd - 1] == 10) {
                --valEnd;
            }
            r.add(new FooterLine(raw, enc, keyStart, keyEnd, valStart, valEnd));
        }
        Collections.reverse(r);
        return r;
    }

    public final List<String> getFooterLines(String keyName) {
        return this.getFooterLines(new FooterKey(keyName));
    }

    public final List<String> getFooterLines(FooterKey keyName) {
        List<FooterLine> src = this.getFooterLines();
        if (src.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>(src.size());
        for (FooterLine f : src) {
            if (!f.matches(keyName)) continue;
            r.add(f.getValue());
        }
        return r;
    }

    public void reset() {
        this.inDegree = 0;
    }

    public final void disposeBody() {
        this.buffer = null;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(Constants.typeString(this.getType()));
        s.append(' ');
        s.append(this.name());
        s.append(' ');
        s.append(this.commitTime);
        s.append(' ');
        this.appendCoreFlags(s);
        return s.toString();
    }
}

