/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.lib;

import axion.org.eclipse.jgit.annotations.NonNull;
import axion.org.eclipse.jgit.annotations.Nullable;
import axion.org.eclipse.jgit.lib.BatchRefUpdate;
import axion.org.eclipse.jgit.lib.ObjectId;
import axion.org.eclipse.jgit.lib.Ref;
import axion.org.eclipse.jgit.lib.RefRename;
import axion.org.eclipse.jgit.lib.RefUpdate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    public static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create() throws IOException;

    public abstract void close();

    public boolean hasVersioning() {
        return false;
    }

    public abstract boolean isNameConflicting(String var1) throws IOException;

    @NonNull
    public Collection<String> getConflictingNames(String name) throws IOException {
        Map<String, Ref> allRefs = this.getRefs(ALL);
        int lastSlash = name.lastIndexOf(47);
        while (lastSlash > 0) {
            String needle = name.substring(0, lastSlash);
            if (allRefs.containsKey(needle)) {
                return Collections.singletonList(needle);
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        ArrayList<String> conflicting = new ArrayList<String>();
        String prefix = String.valueOf(name) + '/';
        for (String existing : allRefs.keySet()) {
            if (!existing.startsWith(prefix)) continue;
            conflicting.add(existing);
        }
        return conflicting;
    }

    @NonNull
    public abstract RefUpdate newUpdate(String var1, boolean var2) throws IOException;

    @NonNull
    public abstract RefRename newRename(String var1, String var2) throws IOException;

    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    @Deprecated
    @Nullable
    public final Ref getRef(String name) throws IOException {
        return this.findRef(name);
    }

    @Nullable
    public final Ref findRef(String name) throws IOException {
        String[] names = new String[SEARCH_PATH.length];
        int i = 0;
        while (i < SEARCH_PATH.length) {
            names[i] = String.valueOf(SEARCH_PATH[i]) + name;
            ++i;
        }
        return this.firstExactRef(names);
    }

    @Nullable
    public abstract Ref exactRef(String var1) throws IOException;

    @NonNull
    public Map<String, Ref> exactRef(String ... refs) throws IOException {
        HashMap<String, Ref> result = new HashMap<String, Ref>(refs.length);
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref ref = this.exactRef(name);
            if (ref != null) {
                result.put(name, ref);
            }
            ++n2;
        }
        return result;
    }

    @Nullable
    public Ref firstExactRef(String ... refs) throws IOException {
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref ref = this.exactRef(name);
            if (ref != null) {
                return ref;
            }
            ++n2;
        }
        return null;
    }

    @NonNull
    public List<Ref> getRefs() throws IOException {
        return this.getRefsByPrefix(ALL);
    }

    @Deprecated
    @NonNull
    public abstract Map<String, Ref> getRefs(String var1) throws IOException;

    @NonNull
    public List<Ref> getRefsByPrefix(String prefix) throws IOException {
        List result;
        int lastSlash = prefix.lastIndexOf(47);
        Map<String, Ref> coarseRefs = lastSlash == -1 ? this.getRefs(ALL) : this.getRefs(prefix.substring(0, lastSlash + 1));
        if (lastSlash + 1 == prefix.length()) {
            result = coarseRefs.values().stream().collect(Collectors.toList());
        } else {
            String p = prefix.substring(lastSlash + 1);
            result = coarseRefs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(p)).map(e -> (Ref)e.getValue()).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(result);
    }

    @NonNull
    public List<Ref> getRefsByPrefixWithExclusions(String include, Set<String> excludes) throws IOException {
        Stream<Ref> refs = this.getRefs(include).values().stream();
        for (String exclude : excludes) {
            refs = refs.filter(r -> !r.getName().startsWith(exclude));
        }
        return Collections.unmodifiableList(refs.collect(Collectors.toList()));
    }

    @NonNull
    public List<Ref> getRefsByPrefix(String ... prefixes) throws IOException {
        ArrayList<Ref> result = new ArrayList<Ref>();
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            result.addAll(this.getRefsByPrefix(prefix));
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    @NonNull
    public Set<Ref> getTipsWithSha1(ObjectId id) throws IOException {
        return this.getRefs().stream().filter(r -> id.equals(r.getObjectId()) || id.equals(r.getPeeledObjectId())).collect(Collectors.toSet());
    }

    public boolean hasFastTipsWithSha1() throws IOException {
        return false;
    }

    public boolean hasRefs() throws IOException {
        return !this.getRefs().isEmpty();
    }

    @NonNull
    public abstract List<Ref> getAdditionalRefs() throws IOException;

    @NonNull
    public abstract Ref peel(Ref var1) throws IOException;

    public void refresh() {
    }

    @Nullable
    public static Ref findRef(Map<String, Ref> map, String name) {
        String[] stringArray = SEARCH_PATH;
        int n = SEARCH_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String fullname = String.valueOf(prefix) + name;
            Ref ref = map.get(fullname);
            if (ref != null) {
                return ref;
            }
            ++n2;
        }
        return null;
    }
}

