/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.transport.sshd;

import axion.org.apache.sshd.common.AttributeRepository;
import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.config.keys.FilePasswordProvider;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.core.CoreModuleProperties;
import axion.org.eclipse.jgit.annotations.NonNull;
import axion.org.eclipse.jgit.transport.URIish;
import axion.org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class PasswordProviderWrapper
implements FilePasswordProvider {
    private static final AttributeRepository.AttributeKey<PerSessionState> STATE = new AttributeRepository.AttributeKey();
    private final Supplier<KeyPasswordProvider> factory;

    public PasswordProviderWrapper(@NonNull Supplier<KeyPasswordProvider> factory) {
        this.factory = factory;
    }

    private PerSessionState getState(SessionContext context) {
        PerSessionState state = context.getAttribute(STATE);
        if (state == null) {
            state = new PerSessionState();
            state.delegate = this.factory.get();
            state.delegate.setAttempts(CoreModuleProperties.PASSWORD_PROMPTS.getRequiredDefault());
            context.setAttribute(STATE, state);
        }
        return state;
    }

    @Override
    public String getPassword(SessionContext session, NamedResource resource, int attemptIndex) throws IOException {
        String key = resource.getName();
        PerSessionState state = this.getState(session);
        int attempt = state.counts.computeIfAbsent(key, k -> new AtomicInteger()).get();
        char[] passphrase = state.delegate.getPassphrase(this.toUri(key), attempt);
        if (passphrase == null) {
            return null;
        }
        try {
            String string = new String(passphrase);
            return string;
        }
        finally {
            Arrays.fill(passphrase, '\u0000');
        }
    }

    @Override
    public FilePasswordProvider.ResourceDecodeResult handleDecodeAttemptResult(SessionContext session, NamedResource resource, int retryIndex, String password, Exception err) throws IOException, GeneralSecurityException {
        String key = resource.getName();
        PerSessionState state = this.getState(session);
        AtomicInteger count = state.counts.get(key);
        int numberOfAttempts = count == null ? 0 : count.incrementAndGet();
        FilePasswordProvider.ResourceDecodeResult result = null;
        try {
            result = state.delegate.keyLoaded(this.toUri(key), numberOfAttempts, err) ? FilePasswordProvider.ResourceDecodeResult.RETRY : FilePasswordProvider.ResourceDecodeResult.TERMINATE;
        }
        finally {
            if (result != FilePasswordProvider.ResourceDecodeResult.RETRY) {
                state.counts.remove(key);
            }
        }
        return result;
    }

    private URIish toUri(String resourceKey) {
        try {
            return new URIish(resourceKey);
        }
        catch (URISyntaxException e) {
            return new URIish().setPath(resourceKey);
        }
    }

    private static class PerSessionState {
        Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();
        KeyPasswordProvider delegate;

        private PerSessionState() {
        }
    }
}

