/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.transport.sshd;

import axion.org.apache.sshd.client.auth.keyboard.UserInteraction;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.session.SessionListener;
import axion.org.eclipse.jgit.transport.CredentialItem;
import axion.org.eclipse.jgit.transport.CredentialsProvider;
import axion.org.eclipse.jgit.transport.URIish;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JGitUserInteraction
implements UserInteraction {
    private final CredentialsProvider provider;
    private final Map<Session, SessionListener> ongoing = new ConcurrentHashMap<Session, SessionListener>();

    public JGitUserInteraction(CredentialsProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean isInteractionAllowed(ClientSession session) {
        return this.provider != null && this.provider.isInteractive();
    }

    @Override
    public String[] interactive(ClientSession session, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        boolean hidden;
        ArrayList<CredentialItem> items = new ArrayList<CredentialItem>();
        int numberOfHiddenInputs = 0;
        int i2 = 0;
        while (i2 < prompt.length) {
            boolean bl = hidden = i2 < echo.length && !echo[i2];
            if (hidden) {
                ++numberOfHiddenInputs;
            }
            ++i2;
        }
        if (name != null && !name.isEmpty()) {
            items.add(new CredentialItem.InformationalMessage(name));
        }
        if (instruction != null && !instruction.isEmpty()) {
            items.add(new CredentialItem.InformationalMessage(instruction));
        }
        i2 = 0;
        while (i2 < prompt.length) {
            boolean bl = hidden = i2 < echo.length && !echo[i2];
            if (hidden && numberOfHiddenInputs == 1) {
                items.add(new CredentialItem.Password());
            } else {
                items.add(new CredentialItem.StringType(prompt[i2], hidden));
            }
            ++i2;
        }
        if (items.isEmpty()) {
            return prompt;
        }
        URIish uri = JGitUserInteraction.toURI(session.getUsername(), (InetSocketAddress)session.getConnectAddress());
        if (numberOfHiddenInputs > 0) {
            SessionListener listener = this.ongoing.get(session);
            if (listener != null) {
                this.provider.reset(uri);
            } else {
                listener = new SessionAuthMarker(this.ongoing);
                this.ongoing.put(session, listener);
                session.addSessionListener(listener);
            }
        }
        if (this.provider.get(uri, items)) {
            return (String[])items.stream().map(i -> {
                if (i instanceof CredentialItem.Password) {
                    return new String(((CredentialItem.Password)i).getValue());
                }
                if (i instanceof CredentialItem.StringType) {
                    return ((CredentialItem.StringType)i).getValue();
                }
                return null;
            }).filter(s -> s != null).toArray(String[]::new);
        }
        return null;
    }

    @Override
    public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
        return null;
    }

    public static URIish toURI(String userName, InetSocketAddress remote) {
        String host = remote.getHostString();
        int port = remote.getPort();
        return new URIish().setScheme("ssh").setHost(host).setPort(port).setUser(userName);
    }

    private static class SessionAuthMarker
    implements SessionListener {
        private final Map<Session, SessionListener> registered;

        public SessionAuthMarker(Map<Session, SessionListener> registered) {
            this.registered = registered;
        }

        @Override
        public void sessionEvent(Session session, SessionListener.Event event) {
            if (event == SessionListener.Event.Authenticated) {
                session.removeSessionListener(this);
                this.registered.remove(session, this);
            }
        }

        @Override
        public void sessionClosed(Session session) {
            session.removeSessionListener(this);
            this.registered.remove(session, this);
        }
    }
}

