/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.storage.file;

import axion.org.eclipse.jgit.internal.storage.file.Pack;
import axion.org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import axion.org.eclipse.jgit.lib.ObjectId;
import java.io.IOException;

class LocalObjectRepresentation
extends StoredObjectRepresentation {
    Pack pack;
    long offset;
    long length;
    private long baseOffset;
    private ObjectId baseId;

    LocalObjectRepresentation() {
    }

    static LocalObjectRepresentation newWhole(Pack pack, long offset, long length) {
        LocalObjectRepresentation r = new LocalObjectRepresentation(){

            @Override
            public int getFormat() {
                return 1;
            }
        };
        r.pack = pack;
        r.offset = offset;
        r.length = length;
        return r;
    }

    static LocalObjectRepresentation newDelta(Pack pack, long offset, long length, ObjectId base) {
        Delta r = new Delta();
        r.pack = pack;
        r.offset = offset;
        r.length = length;
        r.baseId = base;
        return r;
    }

    static LocalObjectRepresentation newDelta(Pack pack, long offset, long length, long base) {
        Delta r = new Delta();
        r.pack = pack;
        r.offset = offset;
        r.length = length;
        r.baseOffset = base;
        return r;
    }

    @Override
    public int getWeight() {
        return (int)Math.min(this.length, Integer.MAX_VALUE);
    }

    @Override
    public ObjectId getDeltaBase() {
        if (this.baseId == null && this.getFormat() == 0) {
            try {
                this.baseId = this.pack.findObjectForOffset(this.baseOffset);
            }
            catch (IOException error) {
                return null;
            }
        }
        return this.baseId;
    }

    private static final class Delta
    extends LocalObjectRepresentation {
        private Delta() {
        }

        @Override
        public int getFormat() {
            return 0;
        }
    }
}

