/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.storage.dfs;

import axion.org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import axion.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import java.io.IOException;
import java.io.InputStream;

final class PackInputStream
extends InputStream {
    final DfsReader ctx;
    private final DfsPackFile pack;
    private long pos;

    PackInputStream(DfsPackFile pack, long pos, DfsReader ctx) throws IOException {
        this.pack = pack;
        this.pos = pos;
        this.ctx = ctx;
        ctx.pin(pack, pos);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.ctx.copy(this.pack, this.pos, b, off, len);
        this.pos += (long)n;
        return n;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, 1);
        return n == 1 ? buf[0] & 0xFF : -1;
    }

    @Override
    public void close() {
        this.ctx.close();
    }
}

