/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.fnmatch;

import axion.org.eclipse.jgit.errors.InvalidPatternException;
import axion.org.eclipse.jgit.fnmatch.AbstractHead;
import axion.org.eclipse.jgit.internal.JGitText;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GroupHead
extends AbstractHead {
    private final List<CharacterPattern> characterClasses = new ArrayList<CharacterPattern>();
    private static final Pattern REGEX_PATTERN = Pattern.compile("([^-][-][^-]|\\[[.:=].*?[.:=]\\])");
    private final boolean inverse;

    GroupHead(String pattern, String wholePattern) throws InvalidPatternException {
        super(false);
        this.inverse = pattern.startsWith("!");
        if (this.inverse) {
            pattern = pattern.substring(1);
        }
        Matcher matcher = REGEX_PATTERN.matcher(pattern);
        while (matcher.find()) {
            String characterClass = matcher.group(0);
            if (characterClass.length() == 3 && characterClass.charAt(1) == '-') {
                char start = characterClass.charAt(0);
                char end = characterClass.charAt(2);
                this.characterClasses.add(new CharacterRange(start, end));
            } else if (characterClass.equals("[:alnum:]")) {
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:alpha:]")) {
                this.characterClasses.add(LetterPattern.INSTANCE);
            } else if (characterClass.equals("[:blank:]")) {
                this.characterClasses.add(new OneCharacterPattern(' '));
                this.characterClasses.add(new OneCharacterPattern('\t'));
            } else if (characterClass.equals("[:cntrl:]")) {
                this.characterClasses.add(new CharacterRange('\u0000', '\u001f'));
                this.characterClasses.add(new OneCharacterPattern('\u007f'));
            } else if (characterClass.equals("[:digit:]")) {
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:graph:]")) {
                this.characterClasses.add(new CharacterRange('!', '~'));
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:lower:]")) {
                this.characterClasses.add(LowerPattern.INSTANCE);
            } else if (characterClass.equals("[:print:]")) {
                this.characterClasses.add(new CharacterRange(' ', '~'));
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else if (characterClass.equals("[:punct:]")) {
                this.characterClasses.add(PunctPattern.INSTANCE);
            } else if (characterClass.equals("[:space:]")) {
                this.characterClasses.add(WhitespacePattern.INSTANCE);
            } else if (characterClass.equals("[:upper:]")) {
                this.characterClasses.add(UpperPattern.INSTANCE);
            } else if (characterClass.equals("[:xdigit:]")) {
                this.characterClasses.add(new CharacterRange('0', '9'));
                this.characterClasses.add(new CharacterRange('a', 'f'));
                this.characterClasses.add(new CharacterRange('A', 'F'));
            } else if (characterClass.equals("[:word:]")) {
                this.characterClasses.add(new OneCharacterPattern('_'));
                this.characterClasses.add(LetterPattern.INSTANCE);
                this.characterClasses.add(DigitPattern.INSTANCE);
            } else {
                String message = MessageFormat.format(JGitText.get().characterClassIsNotSupported, characterClass);
                throw new InvalidPatternException(message, wholePattern);
            }
            pattern = matcher.replaceFirst("");
            matcher.reset(pattern);
        }
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            this.characterClasses.add(new OneCharacterPattern(c));
            ++i;
        }
    }

    @Override
    protected final boolean matches(char c) {
        for (CharacterPattern pattern : this.characterClasses) {
            if (!pattern.matches(c)) continue;
            return !this.inverse;
        }
        return this.inverse;
    }

    private static interface CharacterPattern {
        public boolean matches(char var1);
    }

    private static final class CharacterRange
    implements CharacterPattern {
        private final char start;
        private final char end;

        CharacterRange(char start, char end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public final boolean matches(char c) {
            return this.start <= c && c <= this.end;
        }
    }

    private static final class DigitPattern
    implements CharacterPattern {
        static final DigitPattern INSTANCE = new DigitPattern();

        private DigitPattern() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isDigit(c);
        }
    }

    private static final class LetterPattern
    implements CharacterPattern {
        static final LetterPattern INSTANCE = new LetterPattern();

        private LetterPattern() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isLetter(c);
        }
    }

    private static final class LowerPattern
    implements CharacterPattern {
        static final LowerPattern INSTANCE = new LowerPattern();

        private LowerPattern() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isLowerCase(c);
        }
    }

    private static final class OneCharacterPattern
    implements CharacterPattern {
        private char expectedCharacter;

        OneCharacterPattern(char c) {
            this.expectedCharacter = c;
        }

        @Override
        public final boolean matches(char c) {
            return this.expectedCharacter == c;
        }
    }

    private static final class PunctPattern
    implements CharacterPattern {
        static final PunctPattern INSTANCE = new PunctPattern();
        private static String punctCharacters = "-!\"#$%&'()*+,./:;<=>?@[\\]_`{|}~";

        private PunctPattern() {
        }

        @Override
        public boolean matches(char c) {
            return punctCharacters.indexOf(c) != -1;
        }
    }

    private static final class UpperPattern
    implements CharacterPattern {
        static final UpperPattern INSTANCE = new UpperPattern();

        private UpperPattern() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isUpperCase(c);
        }
    }

    private static final class WhitespacePattern
    implements CharacterPattern {
        static final WhitespacePattern INSTANCE = new WhitespacePattern();

        private WhitespacePattern() {
        }

        @Override
        public final boolean matches(char c) {
            return Character.isWhitespace(c);
        }
    }
}

