/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.awtui;

import axion.org.eclipse.jgit.awtui.AWTPlotRenderer;
import axion.org.eclipse.jgit.awtui.SwingCommitList;
import axion.org.eclipse.jgit.awtui.UIText;
import axion.org.eclipse.jgit.lib.PersonIdent;
import axion.org.eclipse.jgit.revplot.PlotCommit;
import axion.org.eclipse.jgit.revplot.PlotCommitList;
import axion.org.eclipse.jgit.util.References;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CommitGraphPane
extends JTable {
    private static final long serialVersionUID = 1L;
    private final SwingCommitList allCommits = new SwingCommitList();
    static final Stroke[] strokeCache = new Stroke[4];

    static {
        int i = 1;
        while (i < strokeCache.length) {
            CommitGraphPane.strokeCache[i] = new BasicStroke(i);
            ++i;
        }
    }

    public CommitGraphPane() {
        this.configureHeader();
        this.setShowHorizontalLines(false);
        this.setSelectionMode(0);
        this.configureRowHeight();
    }

    private void configureRowHeight() {
        int h = 0;
        int i = 0;
        while (i < this.getColumnCount()) {
            TableCellRenderer renderer = this.getDefaultRenderer(this.getColumnClass(i));
            Component c = renderer.getTableCellRendererComponent(this, "\u00c5Oj", false, false, 0, i);
            h = Math.max(h, c.getPreferredSize().height);
            ++i;
        }
        this.setRowHeight(h + this.getRowMargin());
    }

    public PlotCommitList getCommitList() {
        return this.allCommits;
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (dataModel != null && !(dataModel instanceof CommitTableModel)) {
            throw new ClassCastException(UIText.get().mustBeSpecialTableModel);
        }
        super.setModel(dataModel);
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new CommitTableModel();
    }

    private void configureHeader() {
        JTableHeader th = this.getTableHeader();
        TableColumnModel cols = th.getColumnModel();
        TableColumn graph = cols.getColumn(0);
        TableColumn author = cols.getColumn(1);
        TableColumn date = cols.getColumn(2);
        graph.setHeaderValue("");
        author.setHeaderValue(UIText.get().author);
        date.setHeaderValue(UIText.get().date);
        graph.setCellRenderer(new GraphCellRender());
        author.setCellRenderer(new NameCellRender());
        date.setCellRenderer(new DateCellRender());
    }

    static Stroke stroke(int width) {
        if (width < strokeCache.length) {
            return strokeCache[width];
        }
        return new BasicStroke(width);
    }

    class CommitTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        PlotCommit<SwingCommitList.SwingLane> lastCommit;
        PersonIdent lastAuthor;

        CommitTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return CommitGraphPane.this.allCommits != null ? CommitGraphPane.this.allCommits.size() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PlotCommit c = (PlotCommit)CommitGraphPane.this.allCommits.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return c;
                }
                case 1: {
                    return this.authorFor(c);
                }
                case 2: {
                    return this.authorFor(c);
                }
            }
            return null;
        }

        PersonIdent authorFor(PlotCommit<SwingCommitList.SwingLane> c) {
            if (!References.isSameObject(c, this.lastCommit)) {
                this.lastCommit = c;
                this.lastAuthor = c.getAuthorIdent();
            }
            return this.lastAuthor;
        }
    }

    static class DateCellRender
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        DateCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PersonIdent pi = (PersonIdent)value;
            String valueStr = pi != null ? this.fmt.format(pi.getWhen()) : "";
            return super.getTableCellRendererComponent(table, valueStr, isSelected, hasFocus, row, column);
        }
    }

    static class GraphCellRender
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final AWTPlotRenderer renderer = new AWTPlotRenderer(this);
        PlotCommit<SwingCommitList.SwingLane> commit;

        GraphCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.commit = (PlotCommit)value;
            return this;
        }

        @Override
        protected void paintComponent(Graphics inputGraphics) {
            if (inputGraphics == null) {
                return;
            }
            this.renderer.paint(inputGraphics, this.commit);
        }
    }

    static class NameCellRender
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        NameCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PersonIdent pi = (PersonIdent)value;
            String valueStr = pi != null ? String.valueOf(pi.getName()) + " <" + pi.getEmailAddress() + ">" : "";
            return super.getTableCellRendererComponent(table, valueStr, isSelected, hasFocus, row, column);
        }
    }
}

