/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.api;

import axion.org.eclipse.jgit.api.Git;
import axion.org.eclipse.jgit.api.GitCommand;
import axion.org.eclipse.jgit.api.Status;
import axion.org.eclipse.jgit.api.SubmoduleDeinitResult;
import axion.org.eclipse.jgit.api.errors.GitAPIException;
import axion.org.eclipse.jgit.api.errors.InvalidConfigurationException;
import axion.org.eclipse.jgit.api.errors.JGitInternalException;
import axion.org.eclipse.jgit.api.errors.NoHeadException;
import axion.org.eclipse.jgit.errors.ConfigInvalidException;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.lib.ObjectId;
import axion.org.eclipse.jgit.lib.Ref;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.lib.StoredConfig;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevTree;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import axion.org.eclipse.jgit.submodule.SubmoduleWalk;
import axion.org.eclipse.jgit.treewalk.filter.PathFilter;
import axion.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import axion.org.eclipse.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SubmoduleDeinitCommand
extends GitCommand<Collection<SubmoduleDeinitResult>> {
    private final Collection<String> paths = new ArrayList<String>();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<SubmoduleDeinitResult> call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (String path : this.paths) {
                if (this.submoduleExists(path)) continue;
                throw new NoSuchSubmoduleException(path);
            }
            ArrayList<SubmoduleDeinitResult> results = new ArrayList<SubmoduleDeinitResult>(this.paths.size());
            Object object = null;
            Object var3_6 = null;
            try {
                RevWalk revWalk = new RevWalk(this.repo);
                try {
                    try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                        generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                        StoredConfig config = this.repo.getConfig();
                        while (generator.next()) {
                            String path = generator.getPath();
                            String name = generator.getModuleName();
                            SubmoduleDeinitStatus status = this.checkDirty(revWalk, path);
                            switch (status) {
                                case SUCCESS: {
                                    this.deinit(path);
                                    break;
                                }
                                case ALREADY_DEINITIALIZED: {
                                    break;
                                }
                                case DIRTY: {
                                    if (!this.force) break;
                                    this.deinit(path);
                                    status = SubmoduleDeinitStatus.FORCED;
                                    break;
                                }
                                default: {
                                    throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{status}));
                                }
                            }
                            config.unsetSection("submodule", name);
                            results.add(new SubmoduleDeinitResult(path, status));
                        }
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                    throw object;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            return results;
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void deinit(String path) throws IOException {
        File dir = new File(this.repo.getWorkTree(), path);
        if (!dir.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, path));
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            File[] fileArray = ls;
            int n = ls.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtils.delete(f, 1);
                ++n2;
            }
        }
    }

    /*
     * Loose catch block
     */
    private SubmoduleDeinitStatus checkDirty(RevWalk revWalk, String path) throws GitAPIException, IOException {
        ObjectId submoduleHead;
        SubmoduleWalk w;
        Ref head = this.repo.exactRef("HEAD");
        if (head == null) {
            throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
        }
        RevCommit headCommit = revWalk.parseCommit(head.getObjectId());
        RevTree tree = headCommit.getTree();
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            w = SubmoduleWalk.forPath(this.repo, tree, path);
            try {
                submoduleHead = w.getHead();
                if (submoduleHead == null) {
                    return SubmoduleDeinitStatus.ALREADY_DEINITIALIZED;
                }
                if (!submoduleHead.equals(w.getObjectId())) {
                    return SubmoduleDeinitStatus.DIRTY;
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var8_9 = null;
        try {
            w = SubmoduleWalk.forIndex(this.repo);
            try {
                SubmoduleDeinitStatus submoduleDeinitStatus;
                Repository submoduleRepo;
                Throwable throwable3;
                block37: {
                    if (!w.next()) {
                        return SubmoduleDeinitStatus.DIRTY;
                    }
                    if (!submoduleHead.equals(w.getObjectId())) {
                        return SubmoduleDeinitStatus.DIRTY;
                    }
                    throwable3 = null;
                    Object var11_16 = null;
                    submoduleRepo = w.getRepository();
                    Status status = Git.wrap(submoduleRepo).status().call();
                    submoduleDeinitStatus = status.isClean() ? SubmoduleDeinitStatus.SUCCESS : SubmoduleDeinitStatus.DIRTY;
                    if (submoduleRepo == null) break block37;
                    submoduleRepo.close();
                }
                return submoduleDeinitStatus;
                {
                    catch (Throwable throwable4) {
                        try {
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private boolean submoduleExists(String path) throws IOException {
        PathFilter filter = PathFilter.create(path);
        Throwable throwable = null;
        Object var4_5 = null;
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            return w.setFilter(filter).next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SubmoduleDeinitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public static class NoSuchSubmoduleException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;

        public NoSuchSubmoduleException(String path) {
            super(MessageFormat.format(JGitText.get().noSuchSubmodule, path));
        }
    }

    public static enum SubmoduleDeinitStatus {
        ALREADY_DEINITIALIZED,
        SUCCESS,
        FORCED,
        DIRTY;

    }
}

