/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.api;

import axion.org.eclipse.jgit.api.GitCommand;
import axion.org.eclipse.jgit.api.errors.GitAPIException;
import axion.org.eclipse.jgit.api.errors.JGitInternalException;
import axion.org.eclipse.jgit.api.errors.RefNotFoundException;
import axion.org.eclipse.jgit.errors.InvalidPatternException;
import axion.org.eclipse.jgit.fnmatch.FileNameMatcher;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.lib.ObjectId;
import axion.org.eclipse.jgit.lib.Ref;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevFlag;
import axion.org.eclipse.jgit.revwalk.RevFlagSet;
import axion.org.eclipse.jgit.revwalk.RevTag;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DescribeCommand
extends GitCommand<String> {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;
    private List<FileNameMatcher> matchers = new ArrayList<FileNameMatcher>();
    private boolean useAll;
    private boolean useTags;
    private boolean always;
    private final Comparator<Ref> TAG_TIE_BREAKER = new Comparator<Ref>(){

        @Override
        public int compare(Ref o1, Ref o2) {
            try {
                return this.tagDate(o2).compareTo(this.tagDate(o1));
            }
            catch (IOException e) {
                return 0;
            }
        }

        private Date tagDate(Ref tag) throws IOException {
            RevTag t = DescribeCommand.this.w.parseTag(tag.getObjectId());
            DescribeCommand.this.w.parseBody(t);
            return t.getTaggerIdent().getWhen();
        }
    };

    protected DescribeCommand(Repository repo) {
        super(repo);
        this.w = new RevWalk(repo);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId target) throws IOException {
        this.target = this.w.parseCommit(target);
        return this;
    }

    public DescribeCommand setTarget(String rev) throws IOException, RefNotFoundException {
        ObjectId id = this.repo.resolve(rev);
        if (id == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, rev));
        }
        return this.setTarget(id);
    }

    public DescribeCommand setLong(boolean longDesc) {
        this.longDesc = longDesc;
        return this;
    }

    public DescribeCommand setAll(boolean all) {
        this.useAll = all;
        return this;
    }

    public DescribeCommand setTags(boolean tags) {
        this.useTags = tags;
        return this;
    }

    public DescribeCommand setAlways(boolean always) {
        this.always = always;
        return this;
    }

    private String longDescription(Ref tag, int depth, ObjectId tip) throws IOException {
        return String.format("%s-%d-g%s", this.formatRefName(tag.getName()), depth, this.w.getObjectReader().abbreviate(tip).name());
    }

    public DescribeCommand setMatch(String ... patterns) throws InvalidPatternException {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.matchers.add(new FileNameMatcher(p, null));
            ++n2;
        }
        return this;
    }

    private Optional<Ref> getBestMatch(List<Ref> tags) {
        if (tags == null || tags.isEmpty()) {
            return Optional.empty();
        }
        if (this.matchers.isEmpty()) {
            Collections.sort(tags, this.TAG_TIE_BREAKER);
            return Optional.of(tags.get(0));
        }
        Stream<Ref> matchingTags = Stream.empty();
        for (FileNameMatcher matcher : this.matchers) {
            Stream<Ref> m = tags.stream().filter(tag -> {
                matcher.append(this.formatRefName(tag.getName()));
                boolean result = matcher.isMatch();
                matcher.reset();
                return result;
            });
            matchingTags = Stream.of(matchingTags, m).flatMap(i -> i);
        }
        return matchingTags.sorted(this.TAG_TIE_BREAKER).findFirst();
    }

    private ObjectId getObjectIdFromRef(Ref r) throws JGitInternalException {
        try {
            ObjectId key = this.repo.getRefDatabase().peel(r).getPeeledObjectId();
            if (key == null) {
                key = r.getObjectId();
            }
            return key;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    @Override
    public String call() throws GitAPIException {
        try {
            RevCommit c;
            this.checkCallable();
            if (this.target == null) {
                this.setTarget("HEAD");
            }
            List<Ref> tagList = this.repo.getRefDatabase().getRefsByPrefix(this.useAll ? "refs/" : "refs/tags/");
            Map<ObjectId, List<Ref>> tags = tagList.stream().filter(this::filterLightweightTags).collect(Collectors.groupingBy(this::getObjectIdFromRef));
            RevFlagSet allFlags = new RevFlagSet();
            class Candidate {
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag, RevFlagSet revFlagSet) {
                    this.tag = tag;
                    this.flag = DescribeCommand.this.w.newFlag(tag.getName());
                    revFlagSet.add(this.flag);
                    DescribeCommand.this.w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                String describe(ObjectId tip) throws IOException {
                    return DescribeCommand.this.longDescription(this.tag, this.depth, tip);
                }
            }
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            Optional<Ref> bestMatch = this.getBestMatch(tags.get(this.target));
            if (bestMatch.isPresent()) {
                String string = this.longDesc ? this.longDescription(bestMatch.get(), 0, this.target) : this.formatRefName(bestMatch.get().getName());
                return string;
            }
            this.w.markStart(this.target);
            int seen = 0;
            while ((c = this.w.next()) != null) {
                if (!c.hasAny(allFlags) && (bestMatch = this.getBestMatch(tags.get(c))).isPresent()) {
                    Candidate cd = new Candidate(c, bestMatch.get(), allFlags);
                    candidates.add(cd);
                    cd.depth = seen;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = this.w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    RevCommit[] revCommitArray = c.getParents();
                    int n = revCommitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RevCommit p = revCommitArray[n2];
                        p.add(RevFlag.SEEN);
                        ++n2;
                    }
                    continue;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (candidates.isEmpty()) {
                String string = this.always ? this.w.getObjectReader().abbreviate(this.target).name() : null;
                return string;
            }
            Candidate best = (Candidate)Collections.min(candidates, (o1, o2) -> o1.depth - o2.depth);
            String string = best.describe(this.target);
            return string;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            this.setCallable(false);
            this.w.close();
        }
    }

    private String formatRefName(String name) {
        return name.startsWith("refs/tags/") ? name.substring("refs/tags/".length()) : name.substring("refs/".length());
    }

    private boolean filterLightweightTags(Ref ref) {
        ObjectId id = ref.getObjectId();
        try {
            return this.useAll || this.useTags || id != null && this.w.parseTag(id) != null;
        }
        catch (IOException e) {
            return false;
        }
    }
}

