/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.pqc.jcajce.provider.mceliece;

import axion.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import axion.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import axion.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import axion.org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import axion.org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import axion.org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import axion.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import axion.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import axion.org.bouncycastle.pqc.jcajce.spec.McElieceKeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    McElieceKeyPairGenerator kpg;

    public McElieceKeyPairGeneratorSpi() {
        super("McEliece");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceKeyPairGenerator();
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = (McElieceKeyGenParameterSpec)algorithmParameterSpec;
        McElieceKeyGenerationParameters mcElieceKeyGenerationParameters = new McElieceKeyGenerationParameters(secureRandom, new McElieceParameters(mcElieceKeyGenParameterSpec.getM(), mcElieceKeyGenParameterSpec.getT()));
        this.kpg.init(mcElieceKeyGenerationParameters);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = new McElieceKeyGenParameterSpec();
        try {
            this.initialize(mcElieceKeyGenParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
        McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        McEliecePublicKeyParameters mcEliecePublicKeyParameters = (McEliecePublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        return new KeyPair(new BCMcEliecePublicKey(mcEliecePublicKeyParameters), new BCMcEliecePrivateKey(mcEliecePrivateKeyParameters));
    }
}

