/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.operator.bc;

import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.crypto.Wrapper;
import axion.org.bouncycastle.crypto.params.KeyParameter;
import axion.org.bouncycastle.crypto.params.ParametersWithRandom;
import axion.org.bouncycastle.operator.GenericKey;
import axion.org.bouncycastle.operator.OperatorException;
import axion.org.bouncycastle.operator.SymmetricKeyWrapper;
import axion.org.bouncycastle.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(byArray, 0, byArray.length);
    }
}

