/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.operator.jcajce;

import axion.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.PGPKeyPair;
import axion.org.bouncycastle.openpgp.PGPPrivateKey;
import axion.org.bouncycastle.openpgp.PGPPublicKey;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;

public class JcaPGPKeyPair
extends PGPKeyPair {
    private static PGPPublicKey getPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(n, publicKey, date);
    }

    private static PGPPublicKey getPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(n, pGPAlgorithmParameters, publicKey, date);
    }

    private static PGPPrivateKey getPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPrivateKey(pGPPublicKey, privateKey);
    }

    public JcaPGPKeyPair(int n, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(n, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }

    public JcaPGPKeyPair(int n, PGPAlgorithmParameters pGPAlgorithmParameters, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(n, pGPAlgorithmParameters, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }
}

