/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.operator.bc;

import axion.org.bouncycastle.crypto.Digest;
import axion.org.bouncycastle.crypto.digests.SHA1Digest;
import axion.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import java.io.IOException;
import java.io.OutputStream;

class SHA1PGPDigestCalculator
implements PGPDigestCalculator {
    private Digest digest = new SHA1Digest();

    SHA1PGPDigestCalculator() {
    }

    public int getAlgorithm() {
        return 2;
    }

    public OutputStream getOutputStream() {
        return new DigestOutputStream(this.digest);
    }

    public byte[] getDigest() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }

    public void reset() {
        this.digest.reset();
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

