/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.operator;

import axion.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import axion.org.bouncycastle.math.ec.ECPoint;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import axion.org.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RFC6637KDFCalculator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode("416E6F6E796D6F75732053656E64657220202020");
    private final PGPDigestCalculator digCalc;
    private final int keyAlgorithm;

    public RFC6637KDFCalculator(PGPDigestCalculator pGPDigestCalculator, int n) {
        this.digCalc = pGPDigestCalculator;
        this.keyAlgorithm = n;
    }

    public byte[] createKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, ECPoint eCPoint, byte[] byArray) throws PGPException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = aSN1ObjectIdentifier.getEncoded();
            byteArrayOutputStream.write(byArray2, 1, byArray2.length - 1);
            byteArrayOutputStream.write(18);
            byteArrayOutputStream.write(3);
            byteArrayOutputStream.write(1);
            byteArrayOutputStream.write(this.digCalc.getAlgorithm());
            byteArrayOutputStream.write(this.keyAlgorithm);
            byteArrayOutputStream.write(ANONYMOUS_SENDER);
            byteArrayOutputStream.write(byArray);
            return RFC6637KDFCalculator.KDF(this.digCalc, eCPoint, RFC6637KDFCalculator.getKeyLen(this.keyAlgorithm), byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PGPException("Exception performing KDF: " + iOException.getMessage(), iOException);
        }
    }

    private static byte[] KDF(PGPDigestCalculator pGPDigestCalculator, ECPoint eCPoint, int n, byte[] byArray) throws IOException {
        byte[] byArray2 = eCPoint.getAffineXCoord().getEncoded();
        OutputStream outputStream = pGPDigestCalculator.getOutputStream();
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(1);
        outputStream.write(byArray2);
        outputStream.write(byArray);
        byte[] byArray3 = pGPDigestCalculator.getDigest();
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static int getKeyLen(int n) throws PGPException {
        switch (n) {
            case 7: {
                return 16;
            }
            case 8: {
                return 24;
            }
            case 9: {
                return 32;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + n);
    }
}

