/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.examples;

import axion.org.bouncycastle.bcpg.ArmoredOutputStream;
import axion.org.bouncycastle.bcpg.BCPGOutputStream;
import axion.org.bouncycastle.jce.provider.BouncyCastleProvider;
import axion.org.bouncycastle.openpgp.PGPCompressedData;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.PGPPrivateKey;
import axion.org.bouncycastle.openpgp.PGPPublicKey;
import axion.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import axion.org.bouncycastle.openpgp.PGPSecretKey;
import axion.org.bouncycastle.openpgp.PGPSignature;
import axion.org.bouncycastle.openpgp.PGPSignatureGenerator;
import axion.org.bouncycastle.openpgp.PGPSignatureList;
import axion.org.bouncycastle.openpgp.PGPUtil;
import axion.org.bouncycastle.openpgp.examples.PGPExampleUtil;
import axion.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import axion.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Security;

public class DetachedSignatureProcessor {
    private static void verifySignature(String string, String string2, String string3) throws GeneralSecurityException, IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string3));
        DetachedSignatureProcessor.verifySignature(string, bufferedInputStream, bufferedInputStream2);
        ((InputStream)bufferedInputStream2).close();
        ((InputStream)bufferedInputStream).close();
    }

    private static void verifySignature(String string, InputStream inputStream, InputStream inputStream2) throws GeneralSecurityException, IOException, PGPException {
        int n;
        PGPSignatureList pGPSignatureList;
        Object object;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream = PGPUtil.getDecoderStream(inputStream));
        Object object2 = jcaPGPObjectFactory.nextObject();
        if (object2 instanceof PGPCompressedData) {
            object = (PGPCompressedData)object2;
            jcaPGPObjectFactory = new JcaPGPObjectFactory(((PGPCompressedData)object).getDataStream());
            pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        } else {
            pGPSignatureList = (PGPSignatureList)object2;
        }
        object = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        PGPPublicKey pGPPublicKey = ((PGPPublicKeyRingCollection)object).getPublicKey(pGPSignature.getKeyID());
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        while ((n = ((InputStream)bufferedInputStream).read()) >= 0) {
            pGPSignature.update((byte)n);
        }
        ((InputStream)bufferedInputStream).close();
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void createSignature(String string, String string2, String string3, char[] cArray, boolean bl) throws GeneralSecurityException, IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3));
        DetachedSignatureProcessor.createSignature(string, bufferedInputStream, bufferedOutputStream, cArray, bl);
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
    }

    private static void createSignature(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, boolean bl) throws GeneralSecurityException, IOException, PGPException {
        int n;
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPSecretKey pGPSecretKey = PGPExampleUtil.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(cArray));
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pGPSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        pGPSignatureGenerator.init(0, pGPPrivateKey);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        while ((n = ((InputStream)bufferedInputStream).read()) >= 0) {
            pGPSignatureGenerator.update((byte)n);
        }
        ((InputStream)bufferedInputStream).close();
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        if (bl) {
            outputStream.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            if (stringArray[1].equals("-a")) {
                DetachedSignatureProcessor.createSignature(stringArray[2], stringArray[3], stringArray[2] + ".asc", stringArray[4].toCharArray(), true);
            } else {
                DetachedSignatureProcessor.createSignature(stringArray[1], stringArray[2], stringArray[1] + ".bpg", stringArray[3].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-v")) {
            DetachedSignatureProcessor.verifySignature(stringArray[1], stringArray[2], stringArray[3]);
        } else {
            System.err.println("usage: DetachedSignatureProcessor [-s [-a] file keyfile passPhrase]|[-v file sigFile keyFile]");
        }
    }
}

