/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.math.ec.endo;

import axion.org.bouncycastle.math.ec.ECCurve;
import axion.org.bouncycastle.math.ec.ECPointMap;
import axion.org.bouncycastle.math.ec.ScaleYNegateXPointMap;
import axion.org.bouncycastle.math.ec.endo.EndoUtil;
import axion.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import axion.org.bouncycastle.math.ec.endo.GLVTypeAParameters;
import java.math.BigInteger;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve eCCurve, GLVTypeAParameters gLVTypeAParameters) {
        this.parameters = gLVTypeAParameters;
        this.pointMap = new ScaleYNegateXPointMap(eCCurve.fromBigInteger(gLVTypeAParameters.getI()));
    }

    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }
}

