/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.jce.provider;

import axion.org.bouncycastle.jcajce.PKIXCertRevocationChecker;
import axion.org.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import axion.org.bouncycastle.jcajce.util.JcaJceHelper;
import axion.org.bouncycastle.jce.exception.ExtCertPathValidatorException;
import axion.org.bouncycastle.jce.provider.AnnotatedException;
import axion.org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

class ProvCrlRevocationChecker
implements PKIXCertRevocationChecker {
    private final JcaJceHelper helper;
    private PKIXCertRevocationCheckerParameters params;

    public ProvCrlRevocationChecker(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    public void initialize(PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters) {
        this.params = pKIXCertRevocationCheckerParameters;
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    public void check(Certificate certificate) throws CertPathValidatorException {
        try {
            RFC3280CertPathUtilities.checkCRLs(this.params.getParamsPKIX(), (X509Certificate)certificate, this.params.getValidDate(), this.params.getSigningCert(), this.params.getWorkingPublicKey(), this.params.getCertPath().getCertificates(), this.helper);
        }
        catch (AnnotatedException annotatedException) {
            Throwable throwable = annotatedException;
            if (null != annotatedException.getCause()) {
                throwable = annotatedException.getCause();
            }
            throw new ExtCertPathValidatorException(annotatedException.getMessage(), throwable, this.params.getCertPath(), this.params.getIndex());
        }
    }
}

