/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.jcajce.provider.asymmetric.edec;

import axion.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import axion.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import axion.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import axion.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import axion.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import java.io.IOException;
import java.security.interfaces.XECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;

class BC11XDHPrivateKey
extends BCXDHPrivateKey
implements XECPrivateKey {
    BC11XDHPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC11XDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(privateKeyInfo);
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }

    @Override
    public Optional<byte[]> getScalar() {
        if (this.xdhPrivateKey instanceof X448PrivateKeyParameters) {
            return Optional.of(((X448PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
        }
        return Optional.of(((X25519PrivateKeyParameters)this.xdhPrivateKey).getEncoded());
    }
}

