/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.crypto.ec;

import axion.org.bouncycastle.crypto.CipherParameters;
import axion.org.bouncycastle.crypto.CryptoServicesRegistrar;
import axion.org.bouncycastle.crypto.ec.ECPair;
import axion.org.bouncycastle.crypto.ec.ECPairFactorTransform;
import axion.org.bouncycastle.crypto.ec.ECUtil;
import axion.org.bouncycastle.crypto.params.ECDomainParameters;
import axion.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import axion.org.bouncycastle.crypto.params.ParametersWithRandom;
import axion.org.bouncycastle.math.ec.ECAlgorithms;
import axion.org.bouncycastle.math.ec.ECMultiplier;
import axion.org.bouncycastle.math.ec.ECPoint;
import axion.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewRandomnessTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;
    private BigInteger lastK;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewRandomnessTransform not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        BigInteger bigInteger2 = ECUtil.generateK(bigInteger, this.random);
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getX())), this.key.getQ().multiply(bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getY()))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        this.lastK = bigInteger2;
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    public BigInteger getTransformValue() {
        return this.lastK;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

