/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.cms.bc;

import axion.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import axion.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import axion.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import axion.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import axion.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import axion.org.bouncycastle.cms.CMSAlgorithm;
import axion.org.bouncycastle.cms.CMSException;
import axion.org.bouncycastle.crypto.CipherKeyGenerator;
import axion.org.bouncycastle.crypto.CipherParameters;
import axion.org.bouncycastle.crypto.ExtendedDigest;
import axion.org.bouncycastle.crypto.Wrapper;
import axion.org.bouncycastle.crypto.digests.SHA1Digest;
import axion.org.bouncycastle.crypto.digests.SHA224Digest;
import axion.org.bouncycastle.crypto.digests.SHA256Digest;
import axion.org.bouncycastle.crypto.digests.SHA384Digest;
import axion.org.bouncycastle.crypto.digests.SHA512Digest;
import axion.org.bouncycastle.crypto.engines.AESEngine;
import axion.org.bouncycastle.crypto.engines.DESEngine;
import axion.org.bouncycastle.crypto.engines.DESedeEngine;
import axion.org.bouncycastle.crypto.engines.RC2Engine;
import axion.org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import axion.org.bouncycastle.crypto.params.KeyParameter;
import axion.org.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import axion.org.bouncycastle.crypto.util.CipherFactory;
import axion.org.bouncycastle.crypto.util.CipherKeyGeneratorFactory;
import axion.org.bouncycastle.operator.OperatorCreationException;
import axion.org.bouncycastle.operator.bc.BcDigestProvider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class EnvelopedDataHelper {
    protected static final Map BASE_CIPHER_NAMES = new HashMap();
    protected static final Map MAC_ALG_NAMES = new HashMap();
    private static final Map prfs = EnvelopedDataHelper.createTable();

    private static Map createTable() {
        HashMap<ASN1ObjectIdentifier, BcDigestProvider> hashMap = new HashMap<ASN1ObjectIdentifier, BcDigestProvider>();
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA1, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA1Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA224, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA224Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA256, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA256Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA384, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA384Digest();
            }
        });
        hashMap.put(PKCSObjectIdentifiers.id_hmacWithSHA512, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier algorithmIdentifier) {
                return new SHA512Digest();
            }
        });
        return Collections.unmodifiableMap(hashMap);
    }

    EnvelopedDataHelper() {
    }

    static ExtendedDigest getPRF(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return ((BcDigestProvider)prfs.get(algorithmIdentifier.getAlgorithm())).get(null);
    }

    static Wrapper createRFC3211Wrapper(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes192_CBC.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes256_CBC.equals(aSN1ObjectIdentifier)) {
            return new RFC3211WrapEngine(new AESEngine());
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(aSN1ObjectIdentifier)) {
            return new RFC3211WrapEngine(new DESedeEngine());
        }
        if (OIWObjectIdentifiers.desCBC.equals(aSN1ObjectIdentifier)) {
            return new RFC3211WrapEngine(new DESEngine());
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals(aSN1ObjectIdentifier)) {
            return new RFC3211WrapEngine(new RC2Engine());
        }
        throw new CMSException("cannot recognise wrapper: " + aSN1ObjectIdentifier);
    }

    static Object createContentCipher(boolean bl, CipherParameters cipherParameters, AlgorithmIdentifier algorithmIdentifier) throws CMSException {
        try {
            return CipherFactory.createContentCipher(bl, cipherParameters, algorithmIdentifier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    AlgorithmIdentifier generateEncryptionAlgID(ASN1ObjectIdentifier aSN1ObjectIdentifier, KeyParameter keyParameter, SecureRandom secureRandom) throws CMSException {
        try {
            return AlgorithmIdentifierFactory.generateEncryptionAlgID(aSN1ObjectIdentifier, keyParameter.getKey().length * 8, secureRandom);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, SecureRandom secureRandom) throws CMSException {
        try {
            return CipherKeyGeneratorFactory.createKeyGenerator(aSN1ObjectIdentifier, secureRandom);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    boolean isAuthEnveloped(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return NISTObjectIdentifiers.id_aes128_GCM.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes192_GCM.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes256_GCM.equals(aSN1ObjectIdentifier);
    }

    static {
        BASE_CIPHER_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES256_CBC, "AES");
        MAC_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2Mac");
    }
}

