/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.bcpg;

import axion.org.bouncycastle.bcpg.BCPGInputStream;
import axion.org.bouncycastle.bcpg.BCPGOutputStream;
import axion.org.bouncycastle.bcpg.ContainedPacket;
import axion.org.bouncycastle.util.Arrays;
import axion.org.bouncycastle.util.Strings;
import java.io.IOException;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.idData = bCPGInputStream.readAll();
    }

    public UserIDPacket(String string) {
        this.idData = Strings.toUTF8ByteArray(string);
    }

    public UserIDPacket(byte[] byArray) {
        this.idData = Arrays.clone(byArray);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone(this.idData);
    }

    public boolean equals(Object object) {
        if (object instanceof UserIDPacket) {
            return Arrays.areEqual(this.idData, ((UserIDPacket)object).idData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idData);
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(13, this.idData, true);
    }
}

