/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.server;

import axion.org.apache.sshd.common.session.SessionHolder;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.server.session.ServerSession;
import axion.org.apache.sshd.server.session.ServerSessionHolder;
import axion.org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import axion.org.apache.sshd.sftp.server.UnsupportedAttributePolicy;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface SftpSubsystemEnvironment
extends SessionHolder<ServerSession>,
ServerSessionHolder {
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 6;
    public static final List<Integer> SUPPORTED_SFTP_VERSIONS = Collections.unmodifiableList(IntStream.rangeClosed(3, 6).boxed().collect(Collectors.toList()));
    public static final String ALL_SFTP_IMPL = GenericUtils.join(SUPPORTED_SFTP_VERSIONS, ',');

    @Override
    default public ServerSession getSession() {
        return this.getServerSession();
    }

    public int getVersion();

    public SftpFileSystemAccessor getFileSystemAccessor();

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy();

    public Path getDefaultDirectory();
}

