/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.server;

import axion.org.apache.sshd.server.session.ServerSession;
import axion.org.apache.sshd.sftp.server.Handle;
import axion.org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import axion.org.apache.sshd.sftp.server.SftpSubsystem;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;

public class DirectoryHandle
extends Handle
implements Iterator<Path> {
    private boolean done;
    private boolean sendDotDot = true;
    private boolean sendDot = true;
    private DirectoryStream<Path> ds;
    private Iterator<Path> fileList;

    public DirectoryHandle(SftpSubsystem subsystem, Path dir, String handle) throws IOException {
        super(subsystem, dir, handle);
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        ServerSession session = subsystem.getServerSession();
        this.signalHandleOpening();
        this.ds = accessor.openDirectory(session, subsystem, this, dir, handle);
        Path parent = dir.getParent();
        if (parent == null) {
            this.sendDotDot = false;
        }
        this.fileList = this.ds.iterator();
        try {
            this.signalHandleOpen();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void markDone() {
        this.done = true;
        this.fileList = null;
    }

    public boolean isSendDot() {
        return this.sendDot;
    }

    public void markDotSent() {
        this.sendDot = false;
    }

    public boolean isSendDotDot() {
        return this.sendDotDot;
    }

    public void markDotDotSent() {
        this.sendDotDot = false;
    }

    @Override
    public boolean hasNext() {
        return this.fileList.hasNext();
    }

    @Override
    public Path next() {
        return this.fileList.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not allowed to remove " + this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            SftpSubsystem subsystem = this.getSubsystem();
            SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
            ServerSession session = subsystem.getServerSession();
            accessor.closeDirectory(session, subsystem, this, this.getFile(), this.getFileHandle(), this.ds);
        }
        finally {
            super.close();
            this.markDone();
        }
    }
}

