/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.common.extensions;

import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.buffer.BufferUtils;
import axion.org.apache.sshd.sftp.common.extensions.AbstractParser;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class NewlineParser
extends AbstractParser<Newline> {
    public static final NewlineParser INSTANCE = new NewlineParser();

    public NewlineParser() {
        super("newline");
    }

    @Override
    public Newline parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public Newline parse(String value) {
        return new Newline(value);
    }

    public static class Newline
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 2010656704254497899L;
        private String newline;

        public Newline() {
            this(null);
        }

        public Newline(String newline) {
            this.newline = newline;
        }

        public String getNewline() {
            return this.newline;
        }

        public void setNewline(String newline) {
            this.newline = newline;
        }

        public int hashCode() {
            return Objects.hashCode(this.getNewline());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((Newline)obj).getNewline(), this.getNewline());
        }

        public Newline clone() {
            try {
                return (Newline)this.getClass().cast(super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Failed to clone " + this.toString() + ": " + e.getMessage(), e);
            }
        }

        public String toString() {
            String nl = this.getNewline();
            if (GenericUtils.isEmpty(nl)) {
                return nl;
            }
            return BufferUtils.toHex(':', nl.getBytes(StandardCharsets.UTF_8));
        }
    }
}

