/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.server.forward;

import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.net.SshdSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public interface TcpForwardingFilter {
    public static final TcpForwardingFilter DEFAULT = new TcpForwardingFilter(){

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return true;
        }

        @Override
        public boolean canConnect(Type type, SshdSocketAddress address, Session session) {
            return true;
        }

        public String toString() {
            return TcpForwardingFilter.class.getSimpleName() + "[DEFAULT]";
        }
    };

    public boolean canListen(SshdSocketAddress var1, Session var2);

    public boolean canConnect(Type var1, SshdSocketAddress var2, Session var3);

    public static enum Type implements NamedResource
    {
        Direct("direct-tcpip"),
        Forwarded("forwarded-tcpip");

        public static final Set<Type> VALUES;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        public static Type fromString(String name) {
            if (GenericUtils.isEmpty(name)) {
                return null;
            }
            Type t = Type.fromName(name);
            if (t == null) {
                t = Type.fromEnumName(name);
            }
            return t;
        }

        public static Type fromName(String name) {
            return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
        }

        public static Type fromEnumName(String name) {
            if (GenericUtils.isEmpty(name)) {
                return null;
            }
            for (Type t : VALUES) {
                if (!name.equalsIgnoreCase(t.name())) continue;
                return t;
            }
            return null;
        }

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(Type.class));
        }
    }
}

