/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.server.config;

import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.net.SshdSocketAddress;
import axion.org.apache.sshd.server.forward.TcpForwardingFilter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum AllowTcpForwardingValue implements TcpForwardingFilter
{
    ALL{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return true;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return true;
        }
    }
    ,
    NONE{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return false;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return false;
        }
    }
    ,
    LOCAL{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return true;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return false;
        }
    }
    ,
    REMOTE{

        @Override
        public boolean canListen(SshdSocketAddress address, Session session) {
            return false;
        }

        @Override
        public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
            return true;
        }
    };

    public static final Set<AllowTcpForwardingValue> VALUES;

    public static AllowTcpForwardingValue fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        if ("yes".equalsIgnoreCase(s)) {
            return ALL;
        }
        if ("no".equalsIgnoreCase(s)) {
            return NONE;
        }
        for (AllowTcpForwardingValue v : VALUES) {
            if (!s.equalsIgnoreCase(v.name())) continue;
            return v;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(AllowTcpForwardingValue.class));
    }
}

