/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.logging;

import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.NumberUtils;
import axion.org.apache.sshd.common.util.ReflectionUtils;
import axion.org.apache.sshd.common.util.logging.SimplifiedLog;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.slf4j.Logger;

public final class LoggingUtils {
    private LoggingUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static NavigableMap<Integer, String> generateMnemonicMap(Class<?> clazz, String commonPrefix) {
        return LoggingUtils.generateMnemonicMap(clazz, (? super Field f) -> {
            String name = f.getName();
            return name.startsWith(commonPrefix);
        });
    }

    public static NavigableMap<Integer, String> generateMnemonicMap(Class<?> clazz, Predicate<? super Field> acceptor) {
        Collection<Field> fields = LoggingUtils.getMnemonicFields(clazz, acceptor);
        if (GenericUtils.isEmpty(fields)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<Integer, String> result = new TreeMap<Integer, String>(Comparator.naturalOrder());
        for (Field f : fields) {
            String name = f.getName();
            try {
                Number value = (Number)f.get(null);
                String prev = result.put(NumberUtils.toInteger(value), name);
                if (prev == null) continue;
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static Map<String, Integer> getAmbiguousMenmonics(Class<?> clazz, String commonPrefix) {
        return LoggingUtils.getAmbiguousMenmonics(clazz, (? super Field f) -> {
            String name = f.getName();
            return name.startsWith(commonPrefix);
        });
    }

    public static Map<String, Integer> getAmbiguousMenmonics(Class<?> clazz, Predicate<? super Field> acceptor) {
        Collection<Field> fields = LoggingUtils.getMnemonicFields(clazz, acceptor);
        if (GenericUtils.isEmpty(fields)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        TreeMap opcodesMap = new TreeMap(Comparator.naturalOrder());
        for (Field f : fields) {
            String name = f.getName();
            try {
                Number value = (Number)f.get(null);
                Integer key = NumberUtils.toInteger(value);
                ArrayList<String> nameList = (ArrayList<String>)opcodesMap.get(key);
                if (nameList == null) {
                    nameList = new ArrayList<String>();
                    opcodesMap.put(key, nameList);
                }
                nameList.add(name);
                int numOpcodes = nameList.size();
                if (numOpcodes <= 1) continue;
                result.put(name, key);
                if (numOpcodes != 2) continue;
                result.put((String)nameList.get(0), key);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static Collection<Field> getMnemonicFields(Class<?> clazz, Predicate<? super Field> acceptor) {
        return ReflectionUtils.getMatchingFields(clazz, f -> {
            int mods = f.getModifiers();
            if (!(Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods))) {
                return false;
            }
            Class<?> type = f.getType();
            if (!NumberUtils.isNumericClass(type)) {
                return false;
            }
            return acceptor.test((Field)f);
        });
    }

    public static boolean isLoggable(Level level, Level threshold) {
        if (level == null || threshold == null) {
            return false;
        }
        if (Level.OFF.equals(level) || Level.OFF.equals(threshold)) {
            return false;
        }
        if (Level.ALL.equals(threshold)) {
            return true;
        }
        return level.intValue() >= threshold.intValue();
    }

    public static SimplifiedLog wrap(final Logger logger) {
        if (logger == null) {
            return SimplifiedLog.EMPTY;
        }
        return new SimplifiedLog(){

            @Override
            public void log(Level level, Object message, Throwable t) {
                if (this.isEnabled(level)) {
                    LoggingUtils.logMessage(logger, level, message, t);
                }
            }

            @Override
            public boolean isEnabled(Level level) {
                return LoggingUtils.isLoggable(logger, level);
            }
        };
    }

    public static void logMessage(Logger logger, Level level, Object message, Throwable t) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return;
        }
        if (Level.SEVERE.equals(level)) {
            logger.error(Objects.toString(message), t);
        } else if (Level.WARNING.equals(level)) {
            logger.warn(Objects.toString(message), t);
        } else if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            logger.info(Objects.toString(message), t);
        } else if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            logger.debug(Objects.toString(message), t);
        } else {
            logger.trace(Objects.toString(message), t);
        }
    }

    public static boolean isLoggable(Logger logger, Level level) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return false;
        }
        if (Level.SEVERE.equals(level)) {
            return logger.isErrorEnabled();
        }
        if (Level.WARNING.equals(level)) {
            return logger.isWarnEnabled();
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return logger.isInfoEnabled();
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return logger.isDebugEnabled();
        }
        return logger.isTraceEnabled();
    }

    public static <T> Consumer<T> loggingClosure(Logger logger, Level level) {
        return LoggingUtils.loggingClosure(logger, level, null);
    }

    public static <T> Consumer<T> loggingClosure(Logger logger, Level level, Throwable t) {
        Objects.requireNonNull(level, "No level provided");
        if (Level.OFF.equals(level)) {
            return LoggingUtils.nologClosure(logger);
        }
        if (Level.SEVERE.equals(level)) {
            return LoggingUtils.errorClosure(logger, t);
        }
        if (Level.WARNING.equals(level)) {
            return LoggingUtils.warnClosure(logger, t);
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return LoggingUtils.infoClosure(logger, t);
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return LoggingUtils.debugClosure(logger, t);
        }
        return LoggingUtils.traceClosure(logger, t);
    }

    public static <T> Consumer<T> nologClosure(Logger logger) {
        Objects.requireNonNull(logger, "No logger provided");
        return t -> {};
    }

    public static <T> Consumer<T> errorClosure(Logger logger) {
        return LoggingUtils.errorClosure(logger, null);
    }

    public static <T> Consumer<T> errorClosure(final Logger logger, final Throwable thrown) {
        Objects.requireNonNull(logger, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger.isErrorEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger.error(msg);
                    } else {
                        logger.error(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "ERROR";
            }
        };
    }

    public static <T> Consumer<T> warnClosure(Logger logger) {
        return LoggingUtils.warnClosure(logger, null);
    }

    public static <T> Consumer<T> warnClosure(final Logger logger, final Throwable thrown) {
        Objects.requireNonNull(logger, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger.isWarnEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger.warn(msg);
                    } else {
                        logger.warn(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "WARN";
            }
        };
    }

    public static <T> Consumer<T> infoClosure(Logger logger) {
        return LoggingUtils.infoClosure(logger, null);
    }

    public static <T> Consumer<T> infoClosure(final Logger logger, final Throwable thrown) {
        Objects.requireNonNull(logger, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger.isInfoEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger.info(msg);
                    } else {
                        logger.info(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "INFO";
            }
        };
    }

    public static <T> Consumer<T> debugClosure(Logger logger) {
        return LoggingUtils.debugClosure(logger, null);
    }

    public static <T> Consumer<T> debugClosure(final Logger logger, final Throwable thrown) {
        Objects.requireNonNull(logger, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger.isDebugEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger.debug(msg);
                    } else {
                        logger.debug(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "DEBUG";
            }
        };
    }

    public static <T> Consumer<T> traceClosure(Logger logger) {
        return LoggingUtils.traceClosure(logger, null);
    }

    public static <T> Consumer<T> traceClosure(final Logger logger, final Throwable thrown) {
        Objects.requireNonNull(logger, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger.isTraceEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger.trace(msg);
                    } else {
                        logger.trace(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "TRACE";
            }
        };
    }

    public static void debug(Logger log, String message, Object o1, Object o2, Throwable t) {
        if (log.isTraceEnabled() && t != null) {
            log.debug(message, new Object[]{o1, o2, t});
        } else if (log.isDebugEnabled()) {
            log.debug(message, o1, o2);
        }
    }

    public static void debug(Logger log, String message, Object o1, Object o2, Object o3, Throwable t) {
        if (log.isTraceEnabled() && t != null) {
            log.debug(message, new Object[]{o1, o2, o3, t});
        } else if (log.isDebugEnabled()) {
            log.debug(message, new Object[]{o1, o2, o3});
        }
    }

    public static void debug(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (log.isTraceEnabled() && t != null) {
            log.debug(message, new Object[]{o1, o2, o3, o4, t});
        } else if (log.isDebugEnabled()) {
            log.debug(message, new Object[]{o1, o2, o3, o4});
        }
    }

    public static void debug(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (log.isTraceEnabled() && t != null) {
            log.debug(message, new Object[]{o1, o2, o3, o4, o5, t});
        } else if (log.isDebugEnabled()) {
            log.debug(message, new Object[]{o1, o2, o3, o4, o5});
        }
    }

    public static void debug(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        if (log.isTraceEnabled() && t != null) {
            log.debug(message, new Object[]{o1, o2, o3, o4, o5, o6, t});
        } else if (log.isDebugEnabled()) {
            log.debug(message, new Object[]{o1, o2, o3, o4, o5, o6});
        }
    }

    public static void info(Logger log, String message, Object o1, Object o2, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.info(message, new Object[]{o1, o2, t});
        } else {
            log.info(message, o1, o2);
        }
    }

    public static void info(Logger log, String message, Object o1, Object o2, Object o3, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.info(message, new Object[]{o1, o2, o3, t});
        } else {
            log.info(message, new Object[]{o1, o2, o3});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, t});
        } else {
            log.warn(message, o1, o2);
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, t});
        } else {
            log.warn(message, new Object[]{o1, o2, o3});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, o4, t});
        } else if (log.isDebugEnabled()) {
            log.warn(message, new Object[]{o1, o2, o3, o4});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, t});
        } else {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, t});
        } else {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, o7, t});
        } else {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, o7});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, t});
        } else {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, o7, o8});
        }
    }

    public static void warn(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9, t});
        } else {
            log.warn(message, new Object[]{o1, o2, o3, o4, o5, o6, o7, o8, o9});
        }
    }

    public static void error(Logger log, String message, Object o1, Object o2, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.error(message, new Object[]{o1, o2, t});
        } else {
            log.error(message, o1, o2);
        }
    }

    public static void error(Logger log, String message, Object o1, Object o2, Object o3, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.error(message, new Object[]{o1, o2, o3, t});
        } else {
            log.error(message, new Object[]{o1, o2, o3});
        }
    }

    public static void error(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.error(message, new Object[]{o1, o2, o3, o4, t});
        } else if (log.isDebugEnabled()) {
            log.error(message, new Object[]{o1, o2, o3, o4});
        }
    }

    public static void error(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.error(message, new Object[]{o1, o2, o3, o4, o5, t});
        } else {
            log.error(message, new Object[]{o1, o2, o3, o4, o5});
        }
    }

    public static void error(Logger log, String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        if (log.isDebugEnabled() && t != null) {
            log.error(message, new Object[]{o1, o2, o3, o4, o5, o6, t});
        } else {
            log.error(message, new Object[]{o1, o2, o3, o4, o5, o6});
        }
    }
}

