/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.session.helpers;

import axion.org.apache.sshd.common.future.SshFutureListener;
import axion.org.apache.sshd.common.io.AbstractIoWriteFuture;
import axion.org.apache.sshd.common.io.IoWriteFuture;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import java.util.Objects;

public class PendingWriteFuture
extends AbstractIoWriteFuture
implements SshFutureListener<IoWriteFuture> {
    private final Buffer buffer;

    public PendingWriteFuture(Object id, Buffer buffer) {
        super(id, null);
        this.buffer = Objects.requireNonNull(buffer, "No buffer provided");
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setWritten() {
        this.setValue(Boolean.TRUE);
    }

    public void setException(Throwable cause) {
        Objects.requireNonNull(cause, "No cause specified");
        this.setValue(cause);
    }

    @Override
    public void operationComplete(IoWriteFuture future) {
        if (future.isWritten()) {
            this.setWritten();
        } else {
            this.setException(future.getException());
        }
    }
}

