/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.forward;

import axion.org.apache.sshd.common.forward.DefaultForwarder;
import axion.org.apache.sshd.common.forward.Forwarder;
import axion.org.apache.sshd.common.forward.ForwarderFactory;
import axion.org.apache.sshd.common.forward.PortForwardingEventListener;
import axion.org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import axion.org.apache.sshd.common.session.ConnectionService;
import axion.org.apache.sshd.common.util.EventListenerUtils;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;

public class DefaultForwarderFactory
implements ForwarderFactory,
PortForwardingEventListenerManager {
    public static final DefaultForwarderFactory INSTANCE = new DefaultForwarderFactory(){

        @Override
        public void addPortForwardingEventListener(PortForwardingEventListener listener) {
            throw new UnsupportedOperationException("addPortForwardingListener(" + listener + ") N/A on default instance");
        }

        @Override
        public void removePortForwardingEventListener(PortForwardingEventListener listener) {
            throw new UnsupportedOperationException("removePortForwardingEventListener(" + listener + ") N/A on default instance");
        }

        @Override
        public PortForwardingEventListener getPortForwardingEventListenerProxy() {
            return PortForwardingEventListener.EMPTY;
        }
    };
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final PortForwardingEventListener listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public Forwarder create(ConnectionService service) {
        DefaultForwarder forwarder = new DefaultForwarder(service);
        forwarder.addPortForwardingEventListenerManager(this);
        return forwarder;
    }
}

