/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.config.keys.impl;

import axion.org.apache.sshd.common.config.keys.IdentityResourceLoader;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Objects;

public abstract class AbstractIdentityResourceLoader<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractLoggingBean
implements IdentityResourceLoader<PUB, PRV> {
    private final Class<PUB> pubType;
    private final Class<PRV> prvType;
    private final NavigableSet<String> types;

    protected AbstractIdentityResourceLoader(Class<PUB> pubType, Class<PRV> prvType, Collection<String> keyTypes) {
        this.pubType = Objects.requireNonNull(pubType, "No public key type specified");
        this.prvType = Objects.requireNonNull(prvType, "No private key type specified");
        this.types = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, ValidateUtils.checkNotNullAndNotEmpty(keyTypes, "No key type names provided", new Object[0])));
    }

    @Override
    public final Class<PUB> getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class<PRV> getPrivateKeyType() {
        return this.prvType;
    }

    @Override
    public NavigableSet<String> getSupportedKeyTypes() {
        return this.types;
    }
}

