/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.config;

import axion.org.apache.sshd.common.util.GenericUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;

public enum LogLevelValue {
    QUIET(Level.OFF),
    FATAL(Level.SEVERE),
    ERROR(Level.SEVERE),
    INFO(Level.INFO),
    VERBOSE(Level.FINE),
    DEBUG(Level.FINE),
    DEBUG1(Level.FINE),
    DEBUG2(Level.FINER),
    DEBUG3(Level.FINEST);

    public static final Set<LogLevelValue> VALUES;
    private final Level level;

    private LogLevelValue(Level level) {
        this.level = level;
    }

    public Level getLoggingLevel() {
        return this.level;
    }

    public static LogLevelValue fromName(String n) {
        if (GenericUtils.isEmpty(n)) {
            return null;
        }
        for (LogLevelValue l : VALUES) {
            if (!n.equalsIgnoreCase(l.name())) continue;
            return l;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(LogLevelValue.class));
    }
}

