/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.channel;

import axion.org.apache.sshd.common.channel.ChannelOutputStream;
import axion.org.apache.sshd.common.io.AbstractIoWriteFuture;
import axion.org.apache.sshd.common.io.IoOutputStream;
import axion.org.apache.sshd.common.io.IoWriteFuture;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.closeable.AbstractCloseable;
import axion.org.apache.sshd.common.util.io.IoUtils;
import java.io.Closeable;
import java.io.IOException;

public class SimpleIoOutputStream
extends AbstractCloseable
implements IoOutputStream {
    protected final ChannelOutputStream os;

    public SimpleIoOutputStream(ChannelOutputStream os) {
        this.os = os;
    }

    @Override
    protected void doCloseImmediately() {
        IoUtils.closeQuietly((Closeable)this.os);
        super.doCloseImmediately();
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        this.os.write(buffer.array(), buffer.rpos(), buffer.available());
        this.os.flush();
        DefaultIoWriteFuture f = new DefaultIoWriteFuture(this, null);
        f.setValue(true);
        return f;
    }

    protected static class DefaultIoWriteFuture
    extends AbstractIoWriteFuture {
        public DefaultIoWriteFuture(Object id, Object lock) {
            super(id, lock);
        }
    }
}

