/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.config.hosts;

import axion.org.apache.sshd.client.config.hosts.ConfigFileHostEntryResolver;
import axion.org.apache.sshd.client.config.hosts.HostConfigEntry;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;

public class DefaultConfigFileHostEntryResolver
extends ConfigFileHostEntryResolver {
    public static final DefaultConfigFileHostEntryResolver INSTANCE = new DefaultConfigFileHostEntryResolver(true);
    private final boolean strict;

    public DefaultConfigFileHostEntryResolver(boolean strict) {
        this(HostConfigEntry.getDefaultHostConfigFile(), strict, new LinkOption[0]);
    }

    public DefaultConfigFileHostEntryResolver(Path path, boolean strict, LinkOption ... options) {
        super(path, options);
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List<HostConfigEntry> reloadHostConfigEntries(Path path, String host, int port, String username, String proxyJump) throws IOException {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadHostConfigEntries({}@{}:{}/{}) check permissions of {}", new Object[]{username, host, port, proxyJump, path});
            }
            if ((violation = DefaultConfigFileHostEntryResolver.validateStrictConfigFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadHostConfigEntries({}@{}:{}/{}) invalid file={} permissions: {}", new Object[]{username, host, port, proxyJump, path, violation.getKey()});
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadHostConfigEntries(path, host, port, username, proxyJump);
    }
}

