/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.channel;

import axion.org.apache.sshd.client.channel.PtyCapableChannelSession;
import axion.org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.core.CoreModuleProperties;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ChannelShell
extends PtyCapableChannelSession {
    public ChannelShell(PtyChannelConfigurationHolder configHolder, Map<String, ?> env) {
        super(true, configHolder, env);
    }

    @Override
    protected void doOpen() throws IOException {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST shell", (Object)this);
        }
        Session session = this.getSession();
        boolean wantReply = CoreModuleProperties.REQUEST_SHELL_REPLY.getRequired(this);
        Buffer buffer = session.createBuffer((byte)98, 32);
        buffer.putInt(this.getRecipient());
        buffer.putString("shell");
        buffer.putBoolean(wantReply);
        this.addPendingRequest("shell", wantReply);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() throws IOException {
        Date pending = this.removePendingRequest("shell");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}", (Object)this, (Object)pending);
        }
    }

    @Override
    public void handleFailure() throws IOException {
        Date pending = this.removePendingRequest("shell");
        if (pending != null) {
            this.log.warn("handleFailure({}) pending={}", (Object)this, (Object)pending);
            this.close(true);
        }
    }
}

