/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.auth.pubkey;

import axion.org.apache.sshd.client.auth.AbstractUserAuth;
import axion.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import axion.org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.NamedFactory;
import axion.org.apache.sshd.common.RuntimeSshException;
import axion.org.apache.sshd.common.SshConstants;
import axion.org.apache.sshd.common.config.keys.KeyUtils;
import axion.org.apache.sshd.common.signature.Signature;
import axion.org.apache.sshd.common.signature.SignatureFactoriesHolder;
import axion.org.apache.sshd.common.signature.SignatureFactoriesManager;
import axion.org.apache.sshd.common.signature.SignatureFactory;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.BufferUtils;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    protected Iterator<PublicKeyIdentity> keys;
    protected PublicKeyIdentity current;
    protected List<NamedFactory<Signature>> factories;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.releaseKeys();
        try {
            this.keys = new UserAuthPublicKeyIterator(session, this);
        }
        catch (Error e) {
            this.warn("init({})[{}] failed ({}) to initialize session keys: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        PublicKey key;
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            if (this.keys == null || !this.keys.hasNext()) {
                if (debugEnabled) {
                    this.log.debug("sendAuthDataRequest({})[{}] no more keys to send", (Object)session, (Object)service);
                }
                return false;
            }
            this.current = this.keys.next();
        }
        catch (Error e) {
            this.warn("sendAuthDataRequest({})[{}] failed ({}) to get next key: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}] current key details: {}", new Object[]{session, service, this.current});
        }
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            this.warn("sendAuthDataRequest({})[{}] failed ({}) to retrieve public key: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        String keyType = KeyUtils.getKeyType(key);
        NamedFactory<? extends Signature> factory = this.current instanceof SignatureFactoriesHolder ? SignatureFactory.resolveSignatureFactory(keyType, ((SignatureFactoriesHolder)((Object)this.current)).getSignatureFactories()) : SignatureFactory.resolveSignatureFactory(keyType, this.getSignatureFactories());
        String algo = factory == null ? keyType : factory.getName();
        String name = this.getName();
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", new Object[]{session, service, name, algo, KeyUtils.getFingerPrint(key)});
        }
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(false);
        buffer.putString(algo);
        buffer.putPublicKey(key);
        session.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        PublicKey rspKey;
        String algo;
        PublicKey key;
        String name = this.getName();
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            this.warn("processAuthDataRequest({})[{}][{}] failed ({}) to retrieve public key: {}", session, service, name, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        String curKeyType = KeyUtils.getKeyType(key);
        String rspKeyType = buffer.getString();
        List<String> aliases = KeyUtils.getAllEquivalentKeyTypes(curKeyType);
        if (GenericUtils.isEmpty(aliases)) {
            algo = curKeyType;
            if (!rspKeyType.equals(algo)) {
                throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] mismatched key types: expected=" + algo + ", actual=" + rspKeyType);
            }
        } else {
            if (GenericUtils.findFirstMatchingMember(n -> n.equalsIgnoreCase(rspKeyType), aliases) == null) {
                throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] unsupported key type: expected=" + aliases + ", actual=" + rspKeyType);
            }
            algo = rspKeyType;
        }
        if (!KeyUtils.compareKeys(rspKey = buffer.getPublicKey(), key)) {
            throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] mismatched " + algo + " keys: expected=" + KeyUtils.getFingerPrint(key) + ", actual=" + KeyUtils.getFingerPrint(rspKey));
        }
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}][{}] SSH_MSG_USERAUTH_PK_OK type={}, fingerprint={}", new Object[]{session, service, name, rspKeyType, KeyUtils.getFingerPrint(rspKey)});
        }
        String username = session.getUsername();
        buffer = session.createBuffer((byte)50, GenericUtils.length(username) + GenericUtils.length(service) + GenericUtils.length(name) + GenericUtils.length(algo) + 256 + 64);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(true);
        buffer.putString(algo);
        buffer.putPublicKey(key);
        this.appendSignature(session, service, name, username, algo, key, buffer);
        session.writePacket(buffer);
        return true;
    }

    protected void appendSignature(ClientSession session, String service, String name, String username, String algo, PublicKey key, Buffer buffer) throws Exception {
        byte[] sig;
        byte[] id = session.getSessionId();
        ByteArrayBuffer bs = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + algo.length() + 256 + 64, false);
        bs.putBytes(id);
        ((Buffer)bs).putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putBoolean(true);
        bs.putString(algo);
        bs.putPublicKey(key);
        byte[] contents = bs.getCompactData();
        try {
            Map.Entry<String, byte[]> result = this.current.sign(session, algo, contents);
            String factoryName = result.getKey();
            ValidateUtils.checkState(algo.equalsIgnoreCase(factoryName), "Mismatched signature type generated: requested=%s, used=%s", algo, factoryName);
            sig = result.getValue();
        }
        catch (Error e) {
            this.warn("appendSignature({})[{}][{}] failed ({}) to sign contents using {}: {}", session, service, name, e.getClass().getSimpleName(), algo, e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - verification data={}", new Object[]{session, service, name, algo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(contents)});
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - generated signature={}", new Object[]{session, service, name, algo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(sig)});
        }
        bs.clear();
        bs.putString(algo);
        bs.putBytes(sig);
        buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
    }

    @Override
    public void destroy() {
        try {
            this.releaseKeys();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
        }
        super.destroy();
    }

    protected void releaseKeys() throws IOException {
        try {
            if (this.keys instanceof Closeable) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("releaseKeys({}) closing {}", (Object)this.getClientSession(), this.keys);
                }
                ((Closeable)((Object)this.keys)).close();
            }
        }
        finally {
            this.keys = null;
        }
    }
}

