/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.auth.hostbased;

import axion.org.apache.sshd.common.util.GenericUtils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@FunctionalInterface
public interface HostKeyIdentityProvider {
    public Iterable<? extends Map.Entry<KeyPair, List<X509Certificate>>> loadHostKeys();

    public static Iterator<? extends Map.Entry<KeyPair, List<X509Certificate>>> iteratorOf(HostKeyIdentityProvider provider) {
        return GenericUtils.iteratorOf(provider == null ? null : provider.loadHostKeys());
    }

    public static HostKeyIdentityProvider wrap(KeyPair ... pairs) {
        return HostKeyIdentityProvider.wrap(GenericUtils.asList(pairs));
    }

    public static HostKeyIdentityProvider wrap(Iterable<? extends KeyPair> pairs) {
        return () -> GenericUtils.wrapIterable(pairs, kp -> new AbstractMap.SimpleImmutableEntry((KeyPair)kp, Collections.emptyList()));
    }
}

