/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.agent.local;

import axion.org.apache.sshd.agent.SshAgent;
import axion.org.apache.sshd.agent.SshAgentFactory;
import axion.org.apache.sshd.agent.SshAgentServer;
import axion.org.apache.sshd.agent.local.AgentServerProxy;
import axion.org.apache.sshd.agent.local.LocalAgentFactory;
import axion.org.apache.sshd.agent.unix.AprLibrary;
import axion.org.apache.sshd.agent.unix.UnixAgentFactory;
import axion.org.apache.sshd.common.FactoryManager;
import axion.org.apache.sshd.common.PropertyResolver;
import axion.org.apache.sshd.common.channel.ChannelFactory;
import axion.org.apache.sshd.common.session.ConnectionService;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.core.CoreModuleProperties;
import axion.org.apache.sshd.server.session.ServerSession;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProxyAgentFactory
implements SshAgentFactory {
    private final Map<String, AgentServerProxy> proxies = new ConcurrentHashMap<String, AgentServerProxy>();

    @Override
    public List<ChannelFactory> getChannelForwardingFactories(FactoryManager manager) {
        return ProxyAgentFactory.isPreferredUnixAgent(manager) ? UnixAgentFactory.DEFAULT_FORWARDING_CHANNELS : LocalAgentFactory.DEFAULT_FORWARDING_CHANNELS;
    }

    @Override
    public SshAgent createClient(FactoryManager manager) throws IOException {
        String proxyId = manager.getString("SSH_AUTH_SOCK");
        if (GenericUtils.isEmpty(proxyId)) {
            throw new IllegalStateException("No SSH_AUTH_SOCK environment variable set");
        }
        AgentServerProxy proxy = this.proxies.get(proxyId);
        if (proxy == null) {
            throw new IllegalStateException("No ssh agent found for ID=" + proxyId);
        }
        return proxy.createClient();
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        Object session = service.getSession();
        ValidateUtils.checkInstanceOf(session, ServerSession.class, "The session used to create an agent server proxy must be a server session: %s", session);
        final AgentServerProxy proxy = new AgentServerProxy(service);
        this.proxies.put(proxy.getId(), proxy);
        return new SshAgentServer(){
            private final AtomicBoolean open = new AtomicBoolean(true);

            @Override
            public String getId() {
                return proxy.getId();
            }

            @Override
            public boolean isOpen() {
                return this.open.get() && proxy.isOpen();
            }

            @Override
            public void close() throws IOException {
                if (this.open.getAndSet(false)) {
                    ProxyAgentFactory.this.proxies.remove(proxy.getId());
                    proxy.close();
                }
            }
        };
    }

    public static boolean isPreferredUnixAgent(PropertyResolver resolver) {
        if (CoreModuleProperties.PREFER_UNIX_AGENT.getRequired(resolver).booleanValue()) {
            try {
                if (AprLibrary.getInstance() != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

