/*
 * Decompiled with CFR 0.152.
 */
package axion.com.sun.jna.win32;

import axion.com.sun.jna.DefaultTypeMapper;
import axion.com.sun.jna.FromNativeContext;
import axion.com.sun.jna.StringArray;
import axion.com.sun.jna.ToNativeContext;
import axion.com.sun.jna.TypeConverter;
import axion.com.sun.jna.TypeMapper;
import axion.com.sun.jna.WString;

public class W32APITypeMapper
extends DefaultTypeMapper {
    public static final TypeMapper UNICODE = new W32APITypeMapper(true);
    public static final TypeMapper ASCII = new W32APITypeMapper(false);

    protected W32APITypeMapper(boolean unicode) {
        if (unicode) {
            TypeConverter stringConverter = new TypeConverter(){

                @Override
                public Object toNative(Object value, ToNativeContext context) {
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof String[]) {
                        return new StringArray((String[])value, true);
                    }
                    return new WString(value.toString());
                }

                @Override
                public Object fromNative(Object value, FromNativeContext context) {
                    if (value == null) {
                        return null;
                    }
                    return value.toString();
                }

                @Override
                public Class nativeType() {
                    return WString.class;
                }
            };
            this.addTypeConverter(String.class, stringConverter);
            this.addToNativeConverter(String[].class, stringConverter);
        }
        TypeConverter booleanConverter = new TypeConverter(){

            @Override
            public Object toNative(Object value, ToNativeContext context) {
                return new Integer(Boolean.TRUE.equals(value) ? 1 : 0);
            }

            @Override
            public Object fromNative(Object value, FromNativeContext context) {
                return (Integer)value != 0 ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Class nativeType() {
                return Integer.class;
            }
        };
        this.addTypeConverter(Boolean.class, booleanConverter);
    }
}

