/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import shadow.org.eclipse.jgit.annotations.Nullable;
import shadow.org.eclipse.jgit.errors.CommandFailedException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.transport.CredentialsProvider;
import shadow.org.eclipse.jgit.transport.RemoteSession;
import shadow.org.eclipse.jgit.transport.SshSessionFactory;
import shadow.org.eclipse.jgit.transport.URIish;
import shadow.org.eclipse.jgit.util.FS;
import shadow.org.eclipse.jgit.util.io.MessageWriter;
import shadow.org.eclipse.jgit.util.io.StreamCopyThread;

public class SshSupport {
    public static String runSshCommand(URIish sshUri, @Nullable CredentialsProvider provider, FS fs, String command, int timeout) throws IOException, CommandFailedException {
        String out;
        MessageWriter stdout;
        MessageWriter stderr;
        CommandFailedException failure;
        Process process;
        RemoteSession session;
        block48: {
            StreamCopyThread outThread;
            block46: {
                StreamCopyThread errorThread;
                block40: {
                    session = null;
                    process = null;
                    errorThread = null;
                    outThread = null;
                    failure = null;
                    stderr = new MessageWriter();
                    stdout = new MessageWriter();
                    try {
                        long start = System.nanoTime();
                        session = SshSessionFactory.getInstance().getSession(sshUri, provider, fs, 1000 * timeout);
                        int commandTimeout = timeout;
                        if (timeout > 0) {
                            commandTimeout = SshSupport.checkTimeout(command, timeout, start);
                        }
                        process = session.exec(command, commandTimeout);
                        if (timeout > 0) {
                            commandTimeout = SshSupport.checkTimeout(command, timeout, start);
                        }
                        errorThread = new StreamCopyThread(process.getErrorStream(), stderr.getRawStream());
                        errorThread.start();
                        outThread = new StreamCopyThread(process.getInputStream(), stdout.getRawStream());
                        outThread.start();
                        try {
                            boolean finished = false;
                            if (timeout <= 0) {
                                process.waitFor();
                                finished = true;
                            } else {
                                finished = process.waitFor(commandTimeout, TimeUnit.SECONDS);
                            }
                            if (finished) {
                                out = stdout.toString();
                                break block40;
                            }
                            out = null;
                        }
                        catch (InterruptedException e) {
                            out = null;
                        }
                    }
                    catch (Throwable throwable) {
                        block44: {
                            block42: {
                                if (errorThread != null) {
                                    try {
                                        try {
                                            errorThread.halt();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            errorThread = null;
                                            break block42;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        errorThread = null;
                                        throw throwable2;
                                    }
                                    errorThread = null;
                                }
                            }
                            if (outThread != null) {
                                try {
                                    try {
                                        outThread.halt();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        outThread = null;
                                        break block44;
                                    }
                                }
                                catch (Throwable throwable3) {
                                    outThread = null;
                                    throw throwable3;
                                }
                                outThread = null;
                            }
                        }
                        if (process != null) {
                            try {
                                if (process.exitValue() != 0) {
                                    failure = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command, stderr.toString()));
                                }
                                String out2 = stdout.toString();
                            }
                            catch (IllegalThreadStateException e) {
                                failure = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command, timeout));
                            }
                            process.destroy();
                        }
                        stderr.close();
                        stdout.close();
                        if (session != null) {
                            SshSessionFactory.getInstance().releaseSession(session);
                        }
                        throw throwable;
                    }
                }
                if (errorThread != null) {
                    try {
                        try {
                            errorThread.halt();
                        }
                        catch (InterruptedException e) {
                            errorThread = null;
                            break block46;
                        }
                    }
                    catch (Throwable throwable) {
                        errorThread = null;
                        throw throwable;
                    }
                    errorThread = null;
                }
            }
            if (outThread != null) {
                try {
                    try {
                        outThread.halt();
                    }
                    catch (InterruptedException e) {
                        outThread = null;
                        break block48;
                    }
                }
                catch (Throwable throwable) {
                    outThread = null;
                    throw throwable;
                }
                outThread = null;
            }
        }
        if (process != null) {
            try {
                if (process.exitValue() != 0) {
                    failure = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command, stderr.toString()));
                }
                out = stdout.toString();
            }
            catch (IllegalThreadStateException e) {
                failure = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command, timeout));
            }
            process.destroy();
        }
        stderr.close();
        stdout.close();
        if (session != null) {
            SshSessionFactory.getInstance().releaseSession(session);
        }
        if (failure != null) {
            throw failure;
        }
        return out;
    }

    private static int checkTimeout(String command, int timeout, long since) throws CommandFailedException {
        long elapsed = System.nanoTime() - since;
        int newTimeout = timeout - (int)TimeUnit.NANOSECONDS.toSeconds(elapsed);
        if (newTimeout <= 0) {
            throw new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command, timeout));
        }
        return newTimeout;
    }
}

