/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.transport;

import java.util.Arrays;
import shadow.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import shadow.org.eclipse.jgit.transport.CredentialItem;
import shadow.org.eclipse.jgit.transport.CredentialsProvider;
import shadow.org.eclipse.jgit.transport.URIish;

public class UsernamePasswordCredentialsProvider
extends CredentialsProvider {
    private String username;
    private char[] password;

    public UsernamePasswordCredentialsProvider(String username, String password) {
        this(username, password.toCharArray());
    }

    public UsernamePasswordCredentialsProvider(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.InformationalMessage || i instanceof CredentialItem.Username || i instanceof CredentialItem.Password || i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: "))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.InformationalMessage)) {
                if (i instanceof CredentialItem.Username) {
                    ((CredentialItem.Username)i).setValue(this.username);
                } else if (i instanceof CredentialItem.Password) {
                    ((CredentialItem.Password)i).setValue(this.password);
                } else if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                    ((CredentialItem.StringType)i).setValue(new String(this.password));
                } else {
                    throw new UnsupportedCredentialItem(uri, String.valueOf(i.getClass().getName()) + ":" + i.getPromptText());
                }
            }
            ++n2;
        }
        return true;
    }

    public void clear() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }
}

