/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import shadow.org.eclipse.jgit.errors.NotSupportedException;
import shadow.org.eclipse.jgit.errors.TransportException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.transport.BundleFetchConnection;
import shadow.org.eclipse.jgit.transport.FetchConnection;
import shadow.org.eclipse.jgit.transport.PushConnection;
import shadow.org.eclipse.jgit.transport.Transport;
import shadow.org.eclipse.jgit.transport.TransportBundle;
import shadow.org.eclipse.jgit.transport.URIish;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                try {
                    this.src.close();
                }
                catch (IOException iOException) {
                    this.src = null;
                }
            }
            finally {
                this.src = null;
            }
        }
    }
}

