/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.NullProgressMonitor;
import shadow.org.eclipse.jgit.lib.ProgressMonitor;
import shadow.org.eclipse.jgit.lib.Ref;
import shadow.org.eclipse.jgit.revwalk.RevCommit;
import shadow.org.eclipse.jgit.revwalk.RevObject;
import shadow.org.eclipse.jgit.revwalk.RevWalk;

public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk, start, end).size();
    }

    public static List<RevCommit> find(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk.reset();
        walk.markStart(start);
        if (end != null) {
            walk.markUninteresting(end);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c : walk) {
            commits.add(c);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.findBranchesReachableFrom(commit, revWalk, refs, NullProgressMonitor.INSTANCE);
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs, ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        commit = revWalk.parseCommit(commit.getId());
        revWalk.reset();
        ArrayList<Ref> filteredRefs = new ArrayList<Ref>();
        monitor.beginTask(JGitText.get().searchForReachableBranches, refs.size());
        int SKEW = 86400;
        for (Ref ref : refs) {
            RevCommit headCommit;
            RevObject maybehead = revWalk.parseAny(ref.getObjectId());
            if (!(maybehead instanceof RevCommit) || (headCommit = (RevCommit)maybehead).getCommitTime() + 86400 < commit.getCommitTime()) continue;
            filteredRefs.add(ref);
        }
        List<Ref> result = revWalk.getMergedInto(commit, filteredRefs, monitor);
        monitor.endTask();
        return result;
    }
}

