/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.revwalk;

import java.io.IOException;
import shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.lib.AnyObjectId;
import shadow.org.eclipse.jgit.lib.Constants;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import shadow.org.eclipse.jgit.revwalk.RevFlag;
import shadow.org.eclipse.jgit.revwalk.RevFlagSet;
import shadow.org.eclipse.jgit.revwalk.RevWalk;

public abstract class RevObject
extends ObjectIdOwnerMap.Entry {
    static final int PARSED = 1;
    int flags;

    RevObject(AnyObjectId name) {
        super(name);
    }

    abstract void parseHeaders(RevWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    abstract void parseBody(RevWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract int getType();

    public final ObjectId getId() {
        return this;
    }

    public final boolean has(RevFlag flag) {
        return (this.flags & flag.mask) != 0;
    }

    public final boolean hasAny(RevFlagSet set) {
        return (this.flags & set.mask) != 0;
    }

    public final boolean hasAll(RevFlagSet set) {
        return (this.flags & set.mask) == set.mask;
    }

    public final void add(RevFlag flag) {
        this.flags |= flag.mask;
    }

    public final void add(RevFlagSet set) {
        this.flags |= set.mask;
    }

    public final void remove(RevFlag flag) {
        this.flags &= ~flag.mask;
    }

    public final void remove(RevFlagSet set) {
        this.flags &= ~set.mask;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(Constants.typeString(this.getType()));
        s.append(' ');
        s.append(this.name());
        s.append(' ');
        this.appendCoreFlags(s);
        return s.toString();
    }

    protected void appendCoreFlags(StringBuilder s) {
        s.append((this.flags & 0x20) != 0 ? (char)'o' : '-');
        s.append((this.flags & 0x40) != 0 ? (char)'q' : '-');
        s.append((this.flags & 0x10) != 0 ? (char)'t' : '-');
        s.append((this.flags & 8) != 0 ? (char)'r' : '-');
        s.append((this.flags & 4) != 0 ? (char)'u' : '-');
        s.append((this.flags & 2) != 0 ? (char)'s' : '-');
        s.append((this.flags & 1) != 0 ? (char)'p' : '-');
    }
}

