/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shadow.org.eclipse.jgit.api.CherryPickResult;
import shadow.org.eclipse.jgit.api.Git;
import shadow.org.eclipse.jgit.api.GitCommand;
import shadow.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import shadow.org.eclipse.jgit.api.errors.GitAPIException;
import shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import shadow.org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import shadow.org.eclipse.jgit.api.errors.NoHeadException;
import shadow.org.eclipse.jgit.api.errors.NoMessageException;
import shadow.org.eclipse.jgit.api.errors.UnmergedPathsException;
import shadow.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import shadow.org.eclipse.jgit.dircache.DirCacheCheckout;
import shadow.org.eclipse.jgit.errors.MissingObjectException;
import shadow.org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import shadow.org.eclipse.jgit.internal.JGitText;
import shadow.org.eclipse.jgit.lib.AnyObjectId;
import shadow.org.eclipse.jgit.lib.NullProgressMonitor;
import shadow.org.eclipse.jgit.lib.ObjectId;
import shadow.org.eclipse.jgit.lib.ObjectIdRef;
import shadow.org.eclipse.jgit.lib.ProgressMonitor;
import shadow.org.eclipse.jgit.lib.Ref;
import shadow.org.eclipse.jgit.lib.Repository;
import shadow.org.eclipse.jgit.merge.ContentMergeStrategy;
import shadow.org.eclipse.jgit.merge.MergeMessageFormatter;
import shadow.org.eclipse.jgit.merge.MergeStrategy;
import shadow.org.eclipse.jgit.merge.Merger;
import shadow.org.eclipse.jgit.merge.ResolveMerger;
import shadow.org.eclipse.jgit.revwalk.RevCommit;
import shadow.org.eclipse.jgit.revwalk.RevWalk;
import shadow.org.eclipse.jgit.treewalk.FileTreeIterator;

public class CherryPickCommand
extends GitCommand<CherryPickResult> {
    private String reflogPrefix = "cherry-pick:";
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private Integer mainlineParentNumber;
    private boolean noCommit = false;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    @Override
    public CherryPickResult call() throws GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        RevCommit newHead = null;
        LinkedList<Ref> cherryPickedRefs = new LinkedList<Ref>();
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                Ref headRef = this.repo.exactRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = revWalk.parseCommit(headRef.getObjectId());
                for (Ref src : this.commits) {
                    boolean noProblems;
                    ObjectId srcObjectId = src.getPeeledObjectId();
                    if (srcObjectId == null) {
                        srcObjectId = src.getObjectId();
                    }
                    RevCommit srcCommit = revWalk.parseCommit(srcObjectId);
                    RevCommit srcParent = this.getParentCommit(srcCommit, revWalk);
                    String ourName = this.calculateOurName(headRef);
                    String cherryPickName = String.valueOf(srcCommit.getId().abbreviate(7).name()) + " " + srcCommit.getShortMessage();
                    Merger merger = this.strategy.newMerger(this.repo);
                    merger.setProgressMonitor(this.monitor);
                    Map<String, ResolveMerger.MergeFailureReason> failingPaths = null;
                    List<String> unmergedPaths = null;
                    if (merger instanceof ResolveMerger) {
                        ResolveMerger resolveMerger = (ResolveMerger)merger;
                        resolveMerger.setContentMergeStrategy(this.contentStrategy);
                        resolveMerger.setCommitNames(new String[]{"BASE", ourName, cherryPickName});
                        resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                        resolveMerger.setBase(srcParent.getTree());
                        noProblems = merger.merge(newHead, srcCommit);
                        failingPaths = resolveMerger.getFailingPaths();
                        unmergedPaths = resolveMerger.getUnmergedPaths();
                        if (!resolveMerger.getModifiedFiles().isEmpty()) {
                            this.repo.fireEvent(new WorkingTreeModifiedEvent(resolveMerger.getModifiedFiles(), null));
                        }
                    } else {
                        noProblems = merger.merge(newHead, srcCommit);
                    }
                    if (noProblems) {
                        if (AnyObjectId.isEqual(newHead.getTree().getId(), merger.getResultTreeId())) continue;
                        DirCacheCheckout dco = new DirCacheCheckout(this.repo, newHead.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                        dco.setFailOnConflict(true);
                        dco.setProgressMonitor(this.monitor);
                        dco.checkout();
                        if (!this.noCommit) {
                            Throwable throwable2 = null;
                            Object var20_24 = null;
                            try (Git git = new Git(this.getRepository());){
                                newHead = git.commit().setMessage(srcCommit.getFullMessage()).setReflogComment(String.valueOf(this.reflogPrefix) + " " + srcCommit.getShortMessage()).setAuthor(srcCommit.getAuthorIdent()).setNoVerify(true).call();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        cherryPickedRefs.add(src);
                        continue;
                    }
                    if (failingPaths != null && !failingPaths.isEmpty()) {
                        return new CherryPickResult(failingPaths);
                    }
                    String message = unmergedPaths != null ? new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), unmergedPaths) : srcCommit.getFullMessage();
                    if (!this.noCommit) {
                        this.repo.writeCherryPickHead(srcCommit.getId());
                    }
                    this.repo.writeMergeCommitMsg(message);
                    return CherryPickResult.CONFLICT;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), e);
        }
        return new CherryPickResult(newHead, cherryPickedRefs);
    }

    private RevCommit getParentCommit(RevCommit srcCommit, RevWalk revWalk) throws MultipleParentsNotAllowedException, MissingObjectException, IOException {
        RevCommit srcParent;
        if (this.mainlineParentNumber == null) {
            if (srcCommit.getParentCount() != 1) {
                throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
            }
            srcParent = srcCommit.getParent(0);
        } else {
            if (this.mainlineParentNumber > srcCommit.getParentCount()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().commitDoesNotHaveGivenParent, srcCommit, this.mainlineParentNumber));
            }
            srcParent = srcCommit.getParent(this.mainlineParentNumber - 1);
        }
        revWalk.parseHeaders(srcParent);
        return srcParent;
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public CherryPickCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    public CherryPickCommand setReflogPrefix(String prefix) {
        this.reflogPrefix = prefix;
        return this;
    }

    public CherryPickCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CherryPickCommand setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.contentStrategy = strategy;
        return this;
    }

    public CherryPickCommand setMainlineParentNumber(int mainlineParentNumber) {
        this.mainlineParentNumber = mainlineParentNumber;
        return this;
    }

    public CherryPickCommand setNoCommit(boolean noCommit) {
        this.noCommit = noCommit;
        return this;
    }

    public CherryPickCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public String toString() {
        return "CherryPickCommand [repo=" + this.repo + ",\ncommits=" + this.commits + ",\nmainlineParentNumber=" + this.mainlineParentNumber + ", noCommit=" + this.noCommit + ", ourCommitName=" + this.ourCommitName + ", reflogPrefix=" + this.reflogPrefix + ", strategy=" + this.strategy + "]";
    }
}

