/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pkcs.bc;

import shadow.org.bouncycastle.asn1.DERNull;
import shadow.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.operator.MacCalculator;
import shadow.org.bouncycastle.operator.OperatorCreationException;
import shadow.org.bouncycastle.operator.bc.BcDigestProvider;
import shadow.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import shadow.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import shadow.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider bcDigestProvider) {
        this.digestProvider = bcDigestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pKCS12PBEParams, cArray);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

