/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.operator.bc;

import java.io.IOException;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shadow.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import shadow.org.bouncycastle.crypto.engines.RSABlindedEngine;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.util.PublicKeyFactory;
import shadow.org.bouncycastle.operator.bc.BcAsymmetricKeyWrapper;

public class BcRSAAsymmetricKeyWrapper
extends BcAsymmetricKeyWrapper {
    public BcRSAAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier, asymmetricKeyParameter);
    }

    public BcRSAAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        super(algorithmIdentifier, PublicKeyFactory.createKey(subjectPublicKeyInfo));
    }

    protected AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

